/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.path;

import java.io.File;
import java.util.Set;
import org.mule.munit.remote.path.ApplicationPathCounter;

public class ApplicationPathBuilder {
    public static final String COBERTURA_PORT_PROPERTY = "cobertura.port";
    private static final String MULE_DEBUG_ENABLE_PROPERTY = "mule.debug.enable";
    private static final String MULE_DEBUG_SUSPEND_PROPERTY = "mule.debug.suspend";
    private static final String MULE_DEBUG_PORT_PROPERTY = "mule.debug.port";
    private String resources;
    private Boolean executed = false;
    private ApplicationPathCounter pathCounter;
    private File appDir;

    public ApplicationPathBuilder(String resources, File appDir) {
        this.resources = resources;
        this.appDir = appDir;
    }

    public String getResources() {
        return this.resources;
    }

    public Set<String> getFlowPaths() {
        if (!this.executed.booleanValue()) {
            this.buildApplicationPaths();
        }
        return this.pathCounter.getFlowPaths();
    }

    public Set<String> getSubFlowPaths() {
        if (!this.executed.booleanValue()) {
            this.buildApplicationPaths();
        }
        return this.pathCounter.getSubFlowPaths();
    }

    public Set<String> getBatchPaths() {
        if (!this.executed.booleanValue()) {
            this.buildApplicationPaths();
        }
        return this.pathCounter.getBatchPaths();
    }

    private void buildApplicationPaths() {
        this.executed = true;
        String originalCoveragePort = System.clearProperty(COBERTURA_PORT_PROPERTY);
        String originalDebugEnable = System.clearProperty(MULE_DEBUG_ENABLE_PROPERTY);
        String originalDebugSuspend = System.clearProperty(MULE_DEBUG_SUSPEND_PROPERTY);
        String originalDebugPort = System.clearProperty(MULE_DEBUG_PORT_PROPERTY);
        if (null != originalCoveragePort) {
            System.setProperty(COBERTURA_PORT_PROPERTY, originalCoveragePort);
        }
        if (null != originalDebugEnable) {
            System.setProperty(MULE_DEBUG_ENABLE_PROPERTY, originalDebugEnable);
        }
        if (null != originalDebugSuspend) {
            System.setProperty(MULE_DEBUG_SUSPEND_PROPERTY, originalDebugSuspend);
        }
        if (null != originalDebugPort) {
            System.setProperty(MULE_DEBUG_PORT_PROPERTY, originalDebugPort);
        }
    }
}

