/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
/*
* Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
* copyright law. All use of this software is subject to MuleSoft's Master Subscription
* Agreement (or other master license agreement) separately entered into in writing between
* you and MuleSoft. If such an agreement is not in place, you may not use the software.
*/
package org.mule.munit.remote.api.configuration;

/**
 * Define the configuration required for mule-maven-client
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class MavenConfiguration {

  private String settingsXmlFilePath;
  private String globalSettingsXmlFilePath;
  private String mavenRepositoryDirectoryPath;

  private Boolean forcePolicyUpdate = Boolean.FALSE;

  protected MavenConfiguration(String settingsXmlFilePath, String globalSettingsXmlFilePath,
                               String mavenRepositoryDirectoryPath, Boolean forcePolicyUpdate) {
    this.settingsXmlFilePath = settingsXmlFilePath;
    this.globalSettingsXmlFilePath = globalSettingsXmlFilePath;
    this.mavenRepositoryDirectoryPath = mavenRepositoryDirectoryPath;
    this.forcePolicyUpdate = forcePolicyUpdate;
  }

  public String getSettingsXmlFilePath() {
    return settingsXmlFilePath;
  }

  public String getGlobalSettingsXmlFilePath() {
    return globalSettingsXmlFilePath;
  }

  public String getMavenRepositoryDirectoryPath() {
    return mavenRepositoryDirectoryPath;
  }

  public Boolean getForcePolicyUpdate() {
    return forcePolicyUpdate;
  }

  /**
   * Maven Configuration Builder
   *
   * @author Mulesoft Inc.
   * @since 2.0.0
   */
  public static class MavenConfigurationBuilder {

    private String settingsXmlFilePath;
    private String globalSettingsXmlFilePath;
    private String mavenRepositoryDirectoryPath;
    private Boolean forcePolicyUpdate;

    public MavenConfigurationBuilder withSettingsXmlFilePath(String settingsXmlFilePath) {
      this.settingsXmlFilePath = settingsXmlFilePath;
      return this;
    }

    public MavenConfigurationBuilder withGlobalSettingsXmlFilePath(String globalSettingsXmlFilePath) {
      this.globalSettingsXmlFilePath = globalSettingsXmlFilePath;
      return this;
    }

    public MavenConfigurationBuilder withMavenRepositoryDirectoryPath(String mavenRepositoryDirectoryPath) {
      this.mavenRepositoryDirectoryPath = mavenRepositoryDirectoryPath;
      return this;
    }

    public MavenConfigurationBuilder withForcePolicyUpdate(Boolean forcePolicyUpdate) {
      this.forcePolicyUpdate = forcePolicyUpdate;
      return this;
    }

    public MavenConfiguration build() {
      return new MavenConfiguration(settingsXmlFilePath, globalSettingsXmlFilePath, mavenRepositoryDirectoryPath,
                                    forcePolicyUpdate);
    }
  }
}
