/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.coverage.report;

import static com.google.common.base.Preconditions.checkNotNull;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.mule.munit.plugins.coverage.core.model.CoverageComponentLocation;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.LocationPart;


/**
 * It sorts the location by different criteria
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class LocationGrouper {

  private Set<CoverageComponentLocation> locations;

  public LocationGrouper(Set<CoverageComponentLocation> locations) {
    checkNotNull(locations, "The covered location must not be null");
    this.locations = locations;
  }

  /**
   * It sort the {@link ComponentLocation} by containing flow
   * 
   * @return
   */
  public Map<LocationPart, Set<CoverageComponentLocation>> groupByFlow() {
    Map<LocationPart, Set<CoverageComponentLocation>> locationsPerFlow = new HashMap<>();

    for (CoverageComponentLocation location : locations) {
      LocationPart partIdentifier = location.getParts().get(0);

      if (!locationsPerFlow.containsKey(partIdentifier)) {
        locationsPerFlow.put(partIdentifier, new HashSet<>());
      }
      locationsPerFlow.get(partIdentifier).add(location);

    }
    return locationsPerFlow;
  }

  /**
   * It sorts the {@link ComponentLocation} by containing file
   * 
   * @return
   */
  public Map<String, Set<CoverageComponentLocation>> groupByFile() {

    Map<String, Set<CoverageComponentLocation>> locationsPerFile = new HashMap<>();

    for (CoverageComponentLocation location : locations) {
      String fileName = location.getFileName().get();

      if (!locationsPerFile.containsKey(fileName)) {
        locationsPerFile.put(fileName, new HashSet<>());
      }
      locationsPerFile.get(fileName).add(location);

    }
    return locationsPerFile;
  }

}
