/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.coverage.report.model;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * A model that represents a Mule Flow
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class MuleFlow {

  private String name;
  private List<MuleLocation> locations = new ArrayList<>();
  private List<MuleLocation> coveredLocations = new ArrayList<>();

  private Double branchCoverage;

  public MuleFlow(String name) {
    checkArgument(isNotBlank(name), "The name must not be null nor empty.");
    this.name = name;
  }

  public String getName() {
    return name;
  }

  public List<MuleLocation> getLocations() {
    return locations;
  }

  public void setLocations(List<MuleLocation> locations) {
    checkNotNull(locations, "The locations list must not be null.");
    this.locations = new ArrayList<>(locations);
  }

  public List<MuleLocation> getCoveredLocations() {
    return coveredLocations;
  }

  public void setCoveredLocations(List<MuleLocation> coveredLocations) {
    checkNotNull(locations, "The covered locations list must not be null.");
    this.coveredLocations = new ArrayList<>(coveredLocations);
  }

  public Double getCoverage() {
    int pathCount = locations.size();
    int coveredPathCount = coveredLocations.size();

    if (pathCount > 0) {
      return ((double) coveredPathCount * 100) / pathCount;
    } else {
      return -1.00;
    }
  }

  public Double getBranchCoverage() {
    return branchCoverage;
  }

  public void setBranchCoverage(Double branchCoverage) {
    this.branchCoverage = branchCoverage;
  }

}
