/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.remote.FolderNames;

public class ApplicationStructureGenerator {
    private static final String CLASSLOADER_MODEL_JSON = "classloader-model.json";
    private Path originFolderPath;
    private Path destinationFolderPath;

    public ApplicationStructureGenerator(File sourceFolder, File destinationFolder, String applicationName) {
        Preconditions.checkArgument((boolean)sourceFolder.exists(), (Object)("The source folder " + sourceFolder.getAbsolutePath() + " should exists"));
        Preconditions.checkArgument((boolean)destinationFolder.exists(), (Object)("The destination folder " + destinationFolder.getAbsolutePath() + " should exists"));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)applicationName), (Object)"The application name must not be null nor empty");
        this.originFolderPath = sourceFolder.toPath();
        this.destinationFolderPath = destinationFolder.toPath().resolve(applicationName);
    }

    public void generate() throws Exception {
        this.destinationFolderPath.toFile().mkdir();
        this.copyDirectory(FolderNames.CLASSES.value(), "", true, false);
        this.copyDirectory(FolderNames.TEST_CLASSES.value(), "", false, false);
        this.copyDirectory(FolderNames.TEST_MULE.value(), "", true, false);
        this.copyDirectory(FolderNames.META_INF.value(), FolderNames.META_INF.value(), true, false);
        this.removeClassLoaderModelDescriptorIfPresent();
    }

    private void copyDirectory(String src, String dst, Boolean checkSrc, Boolean doNotCopyIfEmpty) throws Exception {
        Path sourcePath = this.originFolderPath.resolve(src);
        Path destinationPath = this.destinationFolderPath.resolve(dst);
        String srcAbsolutePath = sourcePath.toAbsolutePath().toString();
        String dstAbsolutePath = destinationPath.toAbsolutePath().toString();
        if (checkSrc.booleanValue() && !sourcePath.toFile().exists()) {
            throw new IllegalArgumentException("The source folder " + srcAbsolutePath + " should exists");
        }
        if (!checkSrc.booleanValue() && !sourcePath.toFile().exists()) {
            return;
        }
        try {
            if (doNotCopyIfEmpty.booleanValue() && FileUtils.listFiles((File)sourcePath.toFile(), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE).isEmpty()) {
                return;
            }
            FileUtils.copyDirectory((File)sourcePath.toFile(), (File)destinationPath.toFile());
        }
        catch (IOException e) {
            throw new Exception("Fail to copy content from " + srcAbsolutePath + " to " + dstAbsolutePath, e);
        }
    }

    private void removeClassLoaderModelDescriptorIfPresent() {
        Path destinationPath = this.destinationFolderPath.resolve(FolderNames.META_INF.value()).resolve(FolderNames.MULE_ARTIFACT.value()).resolve(CLASSLOADER_MODEL_JSON);
        if (destinationPath.toFile().exists()) {
            destinationPath.toFile().delete();
        }
    }
}

