/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import org.mule.munit.common.exception.MunitError;
import org.mule.munit.common.util.FileUtils;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;

public class MuleArtifactHandler {
    public static final String MULE_ARTIFACT_JSON = "mule-artifact.json";
    private Path muleArtifactJsonPath;
    private MuleApplicationModel.MuleApplicationModelBuilder originalMuleApplicationModelBuilder;

    public MuleArtifactHandler(Path muleArtifactJsonPath) {
        Preconditions.checkNotNull((Object)muleArtifactJsonPath, (Object)"The mule artifact json path must not be null");
        Preconditions.checkArgument((boolean)muleArtifactJsonPath.toFile().exists(), (Object)(" The file " + muleArtifactJsonPath.toAbsolutePath().toString() + " does not exits"));
        this.muleArtifactJsonPath = muleArtifactJsonPath;
        this.originalMuleApplicationModelBuilder = this.getApplicationModelBuilder(muleArtifactJsonPath.toFile());
    }

    public void restoreOriginal() throws IOException {
        this.updateMuleArtifactFile(this.originalMuleApplicationModelBuilder);
    }

    public void restoreOriginal(Boolean redeployment) throws IOException {
        Boolean originalRedeploymentEnable = ((MuleApplicationModel)this.originalMuleApplicationModelBuilder.build()).isRedeploymentEnabled();
        this.originalMuleApplicationModelBuilder.setRedeploymentEnabled(redeployment.booleanValue());
        this.updateMuleArtifactFile(this.originalMuleApplicationModelBuilder);
        this.originalMuleApplicationModelBuilder.setRedeploymentEnabled(originalRedeploymentEnable.booleanValue());
    }

    public void updateConfigPathAndReDeployment(List<String> configPaths, Boolean redeployment) {
        MuleApplicationModel.MuleApplicationModelBuilder builder = this.getApplicationModelBuilder(this.muleArtifactJsonPath.toFile());
        builder.setConfigs(configPaths);
        builder.setRedeploymentEnabled(redeployment.booleanValue());
        this.updateMuleArtifactFile(builder);
    }

    public void updateConfigPath(List<String> configPaths) {
        MuleApplicationModel.MuleApplicationModelBuilder builder = this.getApplicationModelBuilder(this.muleArtifactJsonPath.toFile());
        builder.setConfigs(configPaths);
        this.updateMuleArtifactFile(builder);
    }

    private void updateMuleArtifactFile(MuleApplicationModel.MuleApplicationModelBuilder builder) {
        String applicationDescriptorContent = new MuleApplicationModelJsonSerializer().serialize((AbstractMuleArtifactModel)builder.build());
        try (FileWriter fileWriter = new FileWriter(this.muleArtifactJsonPath.toAbsolutePath().toString());){
            fileWriter.write(applicationDescriptorContent);
        }
        catch (IOException e) {
            throw new MunitError("Fail to update: " + this.muleArtifactJsonPath.toAbsolutePath().toString(), (Throwable)e);
        }
    }

    private MuleApplicationModel.MuleApplicationModelBuilder getApplicationModelBuilder(File applicationJsonFile) {
        MuleApplicationModel muleApplicationModel = MuleArtifactHandler.getMuleApplicationModel(applicationJsonFile);
        MuleApplicationModel.MuleApplicationModelBuilder builder = new MuleApplicationModel.MuleApplicationModelBuilder();
        builder.setMinMuleVersion(muleApplicationModel.getMinMuleVersion());
        muleApplicationModel.getDomain().ifPresent(arg_0 -> ((MuleApplicationModel.MuleApplicationModelBuilder)builder).setDomain(arg_0));
        builder.setRedeploymentEnabled(muleApplicationModel.isRedeploymentEnabled());
        builder.setName(muleApplicationModel.getName());
        builder.setConfigs(muleApplicationModel.getConfigs());
        builder.withBundleDescriptorLoader(muleApplicationModel.getBundleDescriptorLoader());
        builder.withClassLoaderModelDescriptorLoader(muleApplicationModel.getClassLoaderModelLoaderDescriptor());
        return builder;
    }

    public static MuleApplicationModel getMuleApplicationModel(File applicationJsonFile) {
        String fileContent;
        try {
            fileContent = FileUtils.readFileToString((File)applicationJsonFile, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new MunitError("Fail to read: " + applicationJsonFile.toPath().toAbsolutePath().toString(), (Throwable)e);
        }
        return (MuleApplicationModel)new MuleApplicationModelJsonSerializer().deserialize(fileContent);
    }
}

