/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.munit.common.properties.MUnitUserPropertiesManager;
import org.mule.munit.common.protocol.listeners.RemoteRunEventListener;
import org.mule.munit.common.protocol.listeners.RunEventListener;
import org.mule.munit.common.protocol.listeners.RunEventListenerContainer;
import org.mule.munit.remote.FolderNames;
import org.mule.munit.remote.MuleArtifactHandler;
import org.mule.munit.remote.api.client.RunnerClient;
import org.mule.munit.remote.api.configuration.CoverageConfiguration;
import org.mule.munit.remote.api.configuration.NotifierConfiguration;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.api.configuration.RunConfigurationParser;
import org.mule.munit.remote.classloading.ClassLoaderUtils;
import org.mule.munit.remote.container.ContainerFactory;
import org.mule.munit.remote.container.IllegalPortDefinitionException;
import org.mule.munit.remote.container.MunitRunnerPortProvider;
import org.mule.munit.remote.coverage.CoverageManager;
import org.mule.munit.remote.coverage.report.model.ApplicationCoverageReport;
import org.mule.munit.remote.exception.DeploymentException;
import org.mule.munit.remote.exception.DeploymentExceptionThrower;
import org.mule.munit.remote.notifier.NotifierReflectionFactory;
import org.mule.runtime.module.embedded.api.ArtifactConfiguration;
import org.mule.runtime.module.embedded.api.DeploymentConfiguration;
import org.mule.runtime.module.embedded.api.DeploymentService;
import org.mule.runtime.module.embedded.api.EmbeddedContainer;

public class RemoteRunner {
    public static final String COVERAGE_SEND_ALL_LOCATIONS_PROPERTY = "coverage.send.all.locations";
    public static final String MUNIT_SERVER_PORT = "munit.server.port";
    public static final String SYSTEM_PROPERTIES_FILE = "munit.system.properties.file";
    public static final String MUNIT_DEBUG_LOG_CLASSPATH = "munit.debug.log.classpath";
    private ContainerFactory containerFactory;

    public static void main(String[] args) throws ParseException, IOException, URISyntaxException {
        RemoteRunner.loadSystemPropertiesFileIfPresent();
        RunConfiguration runConfig = new RunConfigurationParser().parse(args);
        RemoteRunner runner = new RemoteRunner();
        runner.setContainerFactory(new ContainerFactory());
        runner.run(runConfig);
        RemoteRunner.shutDown();
    }

    public void setContainerFactory(ContainerFactory containerFactory) {
        this.containerFactory = containerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunConfiguration runConfig) throws IOException, URISyntaxException {
        Integer munitRunnerPort;
        System.out.println("[" + this.getClass().getName() + "]Run Started");
        this.logClassPathIfNecessary();
        RemoteRunEventListener listener = this.buildRunnerListener(runConfig.getNotifierConfigurations());
        listener.notifyRunStart();
        try {
            munitRunnerPort = new MunitRunnerPortProvider().getPort();
        }
        catch (IllegalPortDefinitionException e) {
            listener.notifyUnexpectedError(ExceptionUtils.getStackTrace((Throwable)e));
            listener.notifyRunFinish();
            System.out.println("[" + this.getClass().getName() + "]Done");
            return;
        }
        EmbeddedContainer container = this.containerFactory.createContainer(runConfig.getContainerConfiguration());
        DeploymentConfiguration deploymentConfiguration = DeploymentConfiguration.builder().testDependenciesEnabled(true).build();
        MuleArtifactHandler muleArtifactHandler = this.buildMuleArtifactHandler(runConfig);
        CoverageManager coverageManager = this.buildCoverageManager(runConfig.getCoverageConfiguration());
        try {
            String suitePath;
            boolean success;
            container.start();
            coverageManager.startCoverageServer();
            Iterator<String> iterator = runConfig.getSuitePaths().iterator();
            while (iterator.hasNext() && ((success = this.runSuite(container, runConfig, muleArtifactHandler, deploymentConfiguration, listener, suitePath = iterator.next(), munitRunnerPort)) || !runConfig.isSkipAfterFailure().booleanValue())) {
            }
            if (coverageManager.shouldCalculateCoverage()) {
                this.deployAndUndeployFullApplication(container, runConfig, muleArtifactHandler, deploymentConfiguration);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            listener.notifyUnexpectedError(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            container.stop();
        }
        coverageManager.stopCoverageServer();
        this.sendCoverageReport(coverageManager, listener);
        listener.notifyRunFinish();
        System.out.println("[" + this.getClass().getName() + "]Done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean runSuite(EmbeddedContainer container, RunConfiguration runConfig, MuleArtifactHandler muleArtifactHandler, DeploymentConfiguration deploymentConfiguration, RemoteRunEventListener listener, String suitePath, int port) {
        String applicationName = runConfig.getProjectName();
        String munitWorkingDirectoryPath = runConfig.getContainerConfiguration().getMunitWorkingDirectoryPath();
        try {
            this.updateMuleArtifactJson(suitePath, muleArtifactHandler);
            this.deployApplication(applicationName, deploymentConfiguration, munitWorkingDirectoryPath, container);
            RunnerClient runnerClient = this.buildRunnerClient(listener, port);
            runnerClient.sendSuiteRunInfo(runConfig.getRunToken(), suitePath, runConfig.getTestNames(), runConfig.getTags());
            boolean bl = runnerClient.receiveAndNotify();
            return bl;
        }
        catch (IOException | ClassNotFoundException | RuntimeException | DeploymentException e) {
            listener.notifyContainerFailure(suitePath, ExceptionUtils.getStackTrace((Throwable)e));
            boolean bl = false;
            return bl;
        }
        finally {
            this.undeployApplication(container, applicationName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployAndUndeployFullApplication(EmbeddedContainer container, RunConfiguration runConfig, MuleArtifactHandler muleArtifactHandler, DeploymentConfiguration deploymentConfiguration) {
        String applicationName = runConfig.getProjectName();
        String munitWorkingDirectoryPath = runConfig.getContainerConfiguration().getMunitWorkingDirectoryPath();
        try {
            muleArtifactHandler.restoreOriginal(true);
            System.setProperty(COVERAGE_SEND_ALL_LOCATIONS_PROPERTY, "true");
            System.out.println("[ COVERAGE ] Deploying complete application...");
            this.deployApplication(applicationName, deploymentConfiguration, munitWorkingDirectoryPath, container);
        }
        catch (IOException | RuntimeException | DeploymentException e) {
            System.out.println("[ COVERAGE ] Deploying complete application failed");
        }
        finally {
            this.undeployApplication(container, applicationName);
            System.out.println("[ COVERAGE ] Application undeployed");
            System.clearProperty(COVERAGE_SEND_ALL_LOCATIONS_PROPERTY);
        }
    }

    private void deployApplication(String applicationName, DeploymentConfiguration deploymentConfiguration, String munitWorkingDirectoryPath, EmbeddedContainer container) throws DeploymentException {
        Path artifactLocation = Paths.get(munitWorkingDirectoryPath, applicationName);
        ArtifactConfiguration artifactConfiguration = this.getArtifactConfiguration(artifactLocation, deploymentConfiguration);
        DeploymentService deploymentService = container.getDeploymentService();
        try {
            deploymentService.deployApplication(artifactConfiguration);
        }
        catch (RuntimeException e) {
            DeploymentExceptionThrower.throwIfMatches(e);
        }
    }

    private void undeployApplication(EmbeddedContainer container, String applicationName) {
        container.getDeploymentService().undeployApplication(applicationName);
    }

    private ArtifactConfiguration getArtifactConfiguration(Path artifactLocation, DeploymentConfiguration deploymentConfiguration) {
        return ArtifactConfiguration.builder().deploymentConfiguration(deploymentConfiguration).artifactLocation(artifactLocation.toFile()).build();
    }

    private MuleArtifactHandler buildMuleArtifactHandler(RunConfiguration runConfig) {
        String applicationName = runConfig.getProjectName();
        String munitWorkingDirectoryPath = runConfig.getContainerConfiguration().getMunitWorkingDirectoryPath();
        Path applicationJsonPath = Paths.get(munitWorkingDirectoryPath, applicationName).resolve(FolderNames.META_INF.value()).resolve(FolderNames.MULE_ARTIFACT.value()).resolve("mule-artifact.json");
        return new MuleArtifactHandler(applicationJsonPath);
    }

    private void updateMuleArtifactJson(String suitePath, MuleArtifactHandler muleArtifactHandler) throws IOException {
        Path relativeSuitePath = Paths.get(FolderNames.MUNIT.value(), suitePath);
        muleArtifactHandler.updateConfigPathAndReDeployment(Collections.singletonList(relativeSuitePath.toString()), true);
    }

    protected RunnerClient buildRunnerClient(RemoteRunEventListener listener, int port) throws IOException {
        return new RunnerClient(port, listener);
    }

    protected RemoteRunEventListener buildRunnerListener(List<NotifierConfiguration> configurations) throws IOException {
        List<RunEventListener> listeners = new NotifierReflectionFactory().createNotifiers(configurations);
        RunEventListenerContainer container = new RunEventListenerContainer();
        listeners.forEach(arg_0 -> ((RunEventListenerContainer)container).addNotificationListener(arg_0));
        return container;
    }

    private void logClassPathIfNecessary() {
        if (Boolean.valueOf(System.getProperty(MUNIT_DEBUG_LOG_CLASSPATH, "false")).booleanValue()) {
            System.out.println("[" + this.getClass().getName() + "]logging classpath ...");
            new ClassLoaderUtils().getClassPath().forEach(System.out::println);
            System.out.println("[" + this.getClass().getName() + "]logging classpath DONE");
        }
    }

    private CoverageManager buildCoverageManager(CoverageConfiguration coverageConfiguration) {
        Integer coverageServerPort = coverageConfiguration.getCoveragePort();
        Boolean randomizeCoveragePort = coverageConfiguration.isRandomizeCoveragePort();
        CoverageManager coverageManager = new CoverageManager(randomizeCoveragePort, coverageServerPort, coverageConfiguration.isRunCoverage(), coverageConfiguration.getSuitePaths());
        coverageManager.setIgnoreFlows(Optional.ofNullable(coverageConfiguration.getIgnoredFlowNames()).orElse(Collections.emptySet()));
        coverageManager.setIgnoreFiles(Optional.ofNullable(coverageConfiguration.getIgnoredFiles()).orElse(Collections.emptySet()));
        return coverageManager;
    }

    private void sendCoverageReport(CoverageManager coverageManager, RemoteRunEventListener listener) {
        Optional<ApplicationCoverageReport> coverageReport = coverageManager.generateCoverageReport();
        if (coverageReport.isPresent()) {
            String coverageReportJson = new Gson().toJson((Object)coverageReport.get());
            listener.notifyCoverageReport(coverageReportJson);
        }
    }

    private static void loadSystemPropertiesFileIfPresent() {
        String filePath = System.getProperty(SYSTEM_PROPERTIES_FILE);
        try {
            if (filePath != null) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(new File(filePath)));
                MUnitUserPropertiesManager.loadPropertiesToSystem((Properties)properties);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void shutDown() {
        System.exit(0);
    }
}

