/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.container;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.api.model.RemoteRepository;
import org.mule.munit.common.util.IOUtils;
import org.mule.munit.remote.FolderNames;
import org.mule.munit.remote.api.configuration.ServerPluginConfiguration;
import org.mule.munit.remote.container.BundleDescriptorFactory;
import org.mule.runtime.module.embedded.api.ContainerConfiguration;
import org.mule.runtime.module.embedded.api.EmbeddedContainer;
import org.mule.runtime.module.embedded.api.Product;

public class ContainerFactory {
    protected static final String MAVEN_CENTRAL_ID = "maven-central";
    protected static final String MULESOFT_PUBLIC_ID = "mulesoft-public";
    protected static final String MAVEN_CENTRAL_URL = "https://repo.maven.apache.org/maven2/";
    protected static final String MULESOFT_PUBLIC_URL = "https://repository.mulesoft.org/nexus/content/repositories/public";
    protected static final String DEFAULT_LOG4J2_CONFIG = "default-log4j2-config.xml";

    public EmbeddedContainer createContainer(org.mule.munit.remote.api.configuration.ContainerConfiguration configuration) throws IOException {
        Path munitWorkingDirectoryPath = Paths.get(configuration.getMunitWorkingDirectoryPath(), new String[0]);
        File containerBaseFolder = munitWorkingDirectoryPath.resolve(FolderNames.CONTAINER.value()).toFile();
        String runtimeVersion = configuration.getRuntimeId();
        String product = configuration.getProduct();
        URI log4JConfiguration = this.getLog4JConfiguration(configuration);
        BundleDescriptor[] serverPlugins = BundleDescriptorFactory.buildServerPluginDescriptors(configuration.getServerPluginConfigurations());
        this.loadServerPluginProperties(configuration.getServerPluginConfigurations());
        ContainerConfiguration containerConfiguration = ContainerConfiguration.builder().containerFolder(containerBaseFolder).serverPlugins(serverPlugins).build();
        return EmbeddedContainer.builder().muleVersion(runtimeVersion).product(Product.valueOf((String)product)).log4jConfigurationFile(log4JConfiguration).containerConfiguration(containerConfiguration).mavenConfiguration(this.getMavenConfiguration(configuration.getMavenConfiguration())).build();
    }

    protected URI getLog4JConfiguration(org.mule.munit.remote.api.configuration.ContainerConfiguration runConfig) throws IOException {
        File log4JConfigurationFile;
        String log4JConfigurationFilePath = runConfig.getLog4JConfigurationFilePath();
        if (StringUtils.isNotBlank((CharSequence)log4JConfigurationFilePath) && (log4JConfigurationFile = Paths.get(log4JConfigurationFilePath, new String[0]).toFile()) != null && log4JConfigurationFile.exists()) {
            return log4JConfigurationFile.toURI();
        }
        return this.getDefaultLog4jConfiguration();
    }

    private URI getDefaultLog4jConfiguration() throws IOException {
        try {
            return IOUtils.getResourceAsUrl((String)DEFAULT_LOG4J2_CONFIG, this.getClass()).toURI();
        }
        catch (URISyntaxException e) {
            throw new IOException("Unable to locate default log4j2 configuration file", e);
        }
    }

    protected void loadServerPluginProperties(List<ServerPluginConfiguration> pluginConfig) {
        if (pluginConfig != null) {
            pluginConfig.stream().filter(config -> config.getProperties() != null).forEach(config -> System.getProperties().putAll(config.getProperties()));
        }
    }

    protected MavenConfiguration getMavenConfiguration(org.mule.munit.remote.api.configuration.MavenConfiguration configuration) throws MalformedURLException {
        File globalSettingsXml;
        File settingsXml;
        File mavenRepository;
        MavenConfiguration.MavenConfigurationBuilder builder = MavenConfiguration.newMavenConfigurationBuilder();
        if (configuration.getMavenRepositoryDirectoryPath() != null && (mavenRepository = Paths.get(configuration.getMavenRepositoryDirectoryPath(), new String[0]).toFile()).exists()) {
            builder.localMavenRepositoryLocation(mavenRepository);
        }
        if (configuration.getSettingsXmlFilePath() != null && (settingsXml = Paths.get(configuration.getSettingsXmlFilePath(), new String[0]).toFile()).exists()) {
            builder.userSettingsLocation(settingsXml);
        }
        if (configuration.getGlobalSettingsXmlFilePath() != null && (globalSettingsXml = Paths.get(configuration.getGlobalSettingsXmlFilePath(), new String[0]).toFile()).exists()) {
            builder.globalSettingsLocation(globalSettingsXml);
        }
        if (configuration.getForcePolicyUpdate().booleanValue()) {
            builder.forcePolicyUpdateNever(false);
        } else {
            builder.forcePolicyUpdateNever(true);
        }
        this.addDefaultRepositories(builder);
        return builder.build();
    }

    protected void addDefaultRepositories(MavenConfiguration.MavenConfigurationBuilder builder) throws MalformedURLException {
        String localM2 = System.getProperty("MU-1107");
        if (StringUtils.isNotBlank((CharSequence)localM2)) {
            builder.remoteRepository(RemoteRepository.newRemoteRepositoryBuilder().id("local_m2").url(new File(localM2).toURL()).build());
        } else {
            builder.remoteRepository(RemoteRepository.newRemoteRepositoryBuilder().id(MAVEN_CENTRAL_ID).url(new URL(MAVEN_CENTRAL_URL)).build());
            builder.remoteRepository(RemoteRepository.newRemoteRepositoryBuilder().id(MULESOFT_PUBLIC_ID).url(new URL(MULESOFT_PUBLIC_URL)).build());
        }
    }
}

