/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.container;

import java.util.Optional;
import org.mule.munit.common.util.FreePortFinder;
import org.mule.munit.remote.container.IllegalPortDefinitionException;

public class MunitRunnerPortProvider {
    protected static final int MIN_PORT_NUMBER = 60000;
    protected static final int MAX_PORT_NUMBER = 60500;
    public static final String MUNIT_SERVER_PORT = "munit.server.port";

    public Integer getPort() throws IllegalPortDefinitionException {
        Optional<Integer> predefinedPort = this.getPredefinedPort();
        Integer port = predefinedPort.orElseGet(this::getAndSetFreePort);
        if (port <= 0) {
            throw new IllegalPortDefinitionException("The defined port [" + port + "] is outside the valid range");
        }
        return port;
    }

    private Optional<Integer> getPredefinedPort() {
        Integer predefinedPort;
        try {
            predefinedPort = Integer.parseInt(System.getProperty(MUNIT_SERVER_PORT));
        }
        catch (NumberFormatException e) {
            predefinedPort = null;
        }
        return Optional.ofNullable(predefinedPort);
    }

    private Integer getAndSetFreePort() {
        FreePortFinder freePortFinder = new FreePortFinder(60000, 60500);
        Integer port = freePortFinder.find();
        System.setProperty(MUNIT_SERVER_PORT, port.toString());
        return port;
    }
}

