/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.coverage.report.model;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.remote.coverage.report.model.MuleLocation;

public class MuleFlow {
    private String name;
    private List<MuleLocation> locations = new ArrayList<MuleLocation>();
    private List<MuleLocation> coveredLocations = new ArrayList<MuleLocation>();
    private Double branchCoverage;

    public MuleFlow(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (Object)"The name must not be null nor empty.");
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<MuleLocation> getLocations() {
        return this.locations;
    }

    public void setLocations(List<MuleLocation> locations) {
        Preconditions.checkNotNull(locations, (Object)"The locations list must not be null.");
        this.locations = new ArrayList<MuleLocation>(locations);
    }

    public List<MuleLocation> getCoveredLocations() {
        return this.coveredLocations;
    }

    public void setCoveredLocations(List<MuleLocation> coveredLocations) {
        Preconditions.checkNotNull(this.locations, (Object)"The covered locations list must not be null.");
        this.coveredLocations = new ArrayList<MuleLocation>(coveredLocations);
    }

    public Double getCoverage() {
        int pathCount = this.locations.size();
        int coveredPathCount = this.coveredLocations.size();
        if (pathCount > 0) {
            return (double)coveredPathCount * 100.0 / (double)pathCount;
        }
        return -1.0;
    }

    public Double getBranchCoverage() {
        return this.branchCoverage;
    }

    public void setBranchCoverage(Double branchCoverage) {
        this.branchCoverage = branchCoverage;
    }
}

