/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.remote.FolderNames;
import org.mule.tools.api.packager.archiver.MuleArchiver;
import org.mule.tools.api.packager.archiver.MuleExplodedArchiver;
import org.mule.tools.api.packager.builder.MulePackageBuilder;
import org.mule.tools.api.packager.packaging.PackagingOptions;
import org.mule.tools.api.packager.sources.DefaultValuesMuleArtifactJsonGenerator;
import org.mule.tools.api.packager.sources.MuleArtifactContentResolver;
import org.mule.tools.api.packager.structure.ProjectStructure;

public class ApplicationStructureGenerator {
    public static final boolean ONLY_MULE_SOURCES = false;
    public static final boolean LIGHTWEIGHT_PACKAGE = true;
    public static final boolean ATTACH_MULE_SOURCES = false;
    public static final boolean TEST_PACKAGE = true;
    private Path baseFolderPath;
    private Path originFolderPath;
    private Path destinationFolderPath;
    private MulePackageBuilder packageBuilder;

    public ApplicationStructureGenerator(Path baseFolderPath, Path sourceFolder, Path destinationFolder, String applicationName) {
        Preconditions.checkArgument((baseFolderPath != null ? 1 : 0) != 0, (Object)"The base folder must not be null");
        Preconditions.checkArgument((sourceFolder != null ? 1 : 0) != 0, (Object)"The source folder must not be null");
        Preconditions.checkArgument((destinationFolder != null ? 1 : 0) != 0, (Object)"The destination folder must not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)applicationName), (Object)"The application name must not be null nor empty");
        this.baseFolderPath = baseFolderPath;
        this.originFolderPath = sourceFolder;
        this.destinationFolderPath = destinationFolder.resolve(applicationName);
        this.packageBuilder = new MulePackageBuilder();
    }

    public MulePackageBuilder getPackageBuilder() {
        return this.packageBuilder;
    }

    public void setPackageBuilder(MulePackageBuilder packageBuilder) {
        this.packageBuilder = packageBuilder;
    }

    public void generate() throws Exception {
        this.createExplodedPackage();
        this.reGenerateMuleArtifactJson();
    }

    private void createExplodedPackage() throws Exception {
        this.packageBuilder.withPackagingOptions(new PackagingOptions(false, true, false, true)).withArchiver((MuleArchiver)new MuleExplodedArchiver()).createPackage(this.originFolderPath, this.destinationFolderPath);
    }

    private void reGenerateMuleArtifactJson() throws IOException {
        Path muleArtifactFolderPath = this.destinationFolderPath.resolve(FolderNames.META_INF.value()).resolve(FolderNames.MULE_ARTIFACT.value());
        ProjectStructure projectStructure = new ProjectStructure(this.baseFolderPath, true);
        MuleArtifactContentResolver muleArtifactContentResolver = new MuleArtifactContentResolver(projectStructure);
        DefaultValuesMuleArtifactJsonGenerator.generate((Path)muleArtifactFolderPath, (Path)muleArtifactFolderPath, (MuleArtifactContentResolver)muleArtifactContentResolver);
    }
}

