/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.mule.munit.common.properties.MUnitUserPropertiesManager;
import org.mule.munit.common.protocol.listeners.RemoteRunEventListener;
import org.mule.munit.common.protocol.listeners.RunEventListener;
import org.mule.munit.common.protocol.listeners.RunEventListenerContainer;
import org.mule.munit.common.util.IllegalPortDefinitionException;
import org.mule.munit.common.util.RunnerPortProvider;
import org.mule.munit.common.util.StackTraceUtil;
import org.mule.munit.remote.api.client.RunnerClient;
import org.mule.munit.remote.api.configuration.CoverageConfiguration;
import org.mule.munit.remote.api.configuration.NotifierConfiguration;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.api.configuration.RunConfigurationParser;
import org.mule.munit.remote.classloading.ClassLoaderUtils;
import org.mule.munit.remote.container.ContainerFactory;
import org.mule.munit.remote.coverage.CoverageManager;
import org.mule.munit.remote.coverage.report.model.ApplicationCoverageReport;
import org.mule.munit.remote.exception.DeploymentException;
import org.mule.munit.remote.exception.DeploymentExceptionThrower;
import org.mule.munit.remote.notifier.NotifierReflectionFactory;
import org.mule.runtime.module.embedded.api.ArtifactConfiguration;
import org.mule.runtime.module.embedded.api.DeploymentConfiguration;
import org.mule.runtime.module.embedded.api.DeploymentService;
import org.mule.runtime.module.embedded.api.EmbeddedContainer;

public class RemoteRunner {
    private static final boolean ENABLE_XML_VALIDATIONS = true;
    private static final boolean ENABLE_LAZY_INITIALIZATION = true;
    private static final String MUNIT_DISABLE_LAZY_INITIALIZATION = "munit.disable.lazy.initialization";
    public static final String SYSTEM_PROPERTIES_FILE = "munit.system.properties.file";
    public static final String MUNIT_DEBUG_LOG_CLASSPATH = "munit.debug.log.classpath";
    private ContainerFactory containerFactory;

    public static void main(String[] args) throws ParseException, IOException, URISyntaxException {
        RemoteRunner.loadSystemPropertiesFileIfPresent();
        RunConfiguration runConfig = new RunConfigurationParser().parse(args);
        RemoteRunner runner = new RemoteRunner();
        runner.setContainerFactory(new ContainerFactory());
        runner.run(runConfig);
        RemoteRunner.shutDown();
    }

    public void setContainerFactory(ContainerFactory containerFactory) {
        this.containerFactory = containerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunConfiguration runConfig) throws IOException, URISyntaxException {
        Integer munitRunnerPort;
        System.out.println("[" + this.getClass().getName() + "]Run Started");
        this.logClassPathIfNecessary();
        RemoteRunEventListener listener = this.buildRunnerListener(runConfig.getNotifierConfigurations());
        listener.notifyRunStart();
        try {
            munitRunnerPort = new RunnerPortProvider().getPort();
        }
        catch (IllegalPortDefinitionException e) {
            listener.notifyUnexpectedError(StackTraceUtil.getStackTrace((Throwable)e));
            listener.notifyRunFinish();
            System.out.println("[" + this.getClass().getName() + "]Done");
            return;
        }
        EmbeddedContainer container = this.containerFactory.createContainer(runConfig.getContainerConfiguration());
        DeploymentConfiguration deploymentConfiguration = DeploymentConfiguration.builder().lazyInitialization(this.enableLazyInitialization().booleanValue()).xmlValidations(true).build();
        CoverageManager coverageManager = this.buildCoverageManager(runConfig.getCoverageConfiguration());
        try {
            String suitePath;
            boolean success;
            container.start();
            coverageManager.startCoverageServer();
            this.deployApplication(runConfig.getProjectName(), deploymentConfiguration, runConfig.getContainerConfiguration().getMunitWorkingDirectoryPath(), container);
            Iterator<String> iterator = runConfig.getSuitePaths().iterator();
            while (iterator.hasNext() && ((success = this.runSuite(runConfig, listener, suitePath = iterator.next(), munitRunnerPort)) || !runConfig.isSkipAfterFailure().booleanValue())) {
            }
            this.undeployApplication(container, runConfig.getProjectName());
        }
        catch (DeploymentException e) {
            listener.notifyContainerFailure(StackTraceUtil.getStackTrace((Throwable)e));
        }
        catch (Throwable e) {
            e.printStackTrace();
            listener.notifyUnexpectedError(StackTraceUtil.getStackTrace((Throwable)e));
        }
        finally {
            container.stop();
        }
        coverageManager.stopCoverageServer();
        this.sendCoverageReport(coverageManager, listener);
        listener.notifyRunFinish();
        System.out.println("[" + this.getClass().getName() + "]Done");
    }

    protected void deployApplication(String applicationName, DeploymentConfiguration deploymentConfiguration, String munitWorkingDirectoryPath, EmbeddedContainer container) throws DeploymentException {
        Path artifactLocation = Paths.get(munitWorkingDirectoryPath, applicationName);
        ArtifactConfiguration artifactConfiguration = this.getArtifactConfiguration(artifactLocation, deploymentConfiguration);
        DeploymentService deploymentService = container.getDeploymentService();
        try {
            deploymentService.deployApplication(artifactConfiguration);
        }
        catch (RuntimeException e) {
            DeploymentExceptionThrower.throwIfMatches(e);
        }
    }

    protected boolean runSuite(RunConfiguration runConfig, RemoteRunEventListener listener, String suitePath, int port) {
        try {
            RunnerClient runnerClient = this.buildRunnerClient(listener, port);
            runnerClient.sendSuiteRunInfo(runConfig.getRunToken(), suitePath, runConfig.getTestNames(), runConfig.getTags());
            return runnerClient.receiveAndNotify();
        }
        catch (IOException | ClassNotFoundException | RuntimeException e) {
            listener.notifyContainerFailure(StackTraceUtil.getStackTrace((Throwable)e));
            return false;
        }
    }

    private void undeployApplication(EmbeddedContainer container, String applicationName) {
        container.getDeploymentService().undeployApplication(applicationName);
    }

    private ArtifactConfiguration getArtifactConfiguration(Path artifactLocation, DeploymentConfiguration deploymentConfiguration) {
        return ArtifactConfiguration.builder().deploymentConfiguration(deploymentConfiguration).artifactLocation(artifactLocation.toFile()).build();
    }

    protected RunnerClient buildRunnerClient(RemoteRunEventListener listener, int port) throws IOException {
        return new RunnerClient(port, listener);
    }

    protected RemoteRunEventListener buildRunnerListener(List<NotifierConfiguration> configurations) throws IOException {
        List<RunEventListener> listeners = new NotifierReflectionFactory().createNotifiers(configurations);
        RunEventListenerContainer container = new RunEventListenerContainer();
        listeners.forEach(arg_0 -> ((RunEventListenerContainer)container).addNotificationListener(arg_0));
        return container;
    }

    private void logClassPathIfNecessary() {
        if (Boolean.valueOf(System.getProperty(MUNIT_DEBUG_LOG_CLASSPATH, "false")).booleanValue()) {
            System.out.println("[" + this.getClass().getName() + "]logging classpath ...");
            new ClassLoaderUtils().getClassPath().forEach(System.out::println);
            System.out.println("[" + this.getClass().getName() + "]logging classpath DONE");
        }
    }

    private CoverageManager buildCoverageManager(CoverageConfiguration coverageConfiguration) {
        Integer coverageServerPort = coverageConfiguration.getCoveragePort();
        Boolean randomizeCoveragePort = coverageConfiguration.isRandomizeCoveragePort();
        CoverageManager coverageManager = new CoverageManager(randomizeCoveragePort, coverageServerPort, coverageConfiguration.isRunCoverage(), coverageConfiguration.getSuitePaths());
        coverageManager.setIgnoreFlows(Optional.ofNullable(coverageConfiguration.getIgnoredFlowNames()).orElse(Collections.emptySet()));
        coverageManager.setIgnoreFiles(Optional.ofNullable(coverageConfiguration.getIgnoredFiles()).orElse(Collections.emptySet()));
        return coverageManager;
    }

    private void sendCoverageReport(CoverageManager coverageManager, RemoteRunEventListener listener) {
        Optional<ApplicationCoverageReport> coverageReport = coverageManager.generateCoverageReport();
        if (coverageReport.isPresent()) {
            String coverageReportJson = new Gson().toJson((Object)coverageReport.get());
            listener.notifyCoverageReport(coverageReportJson);
        }
    }

    private Boolean enableLazyInitialization() {
        if (Boolean.valueOf(System.getProperty(MUNIT_DISABLE_LAZY_INITIALIZATION, "false")).booleanValue()) {
            return false;
        }
        return true;
    }

    private static void loadSystemPropertiesFileIfPresent() {
        String filePath = System.getProperty(SYSTEM_PROPERTIES_FILE);
        try {
            if (filePath != null) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(new File(filePath)));
                MUnitUserPropertiesManager.loadPropertiesToSystem((Properties)properties);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void shutDown() {
        System.exit(0);
    }
}

