/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.api.configuration;

public class MavenConfiguration {
    private String settingsXmlFilePath;
    private String globalSettingsXmlFilePath;
    private String mavenRepositoryDirectoryPath;
    private Boolean offlineMode = Boolean.FALSE;
    private Boolean forcePolicyUpdate = Boolean.FALSE;

    protected MavenConfiguration(String settingsXmlFilePath, String globalSettingsXmlFilePath, String mavenRepositoryDirectoryPath, Boolean forcePolicyUpdate, Boolean offlineMode) {
        this.settingsXmlFilePath = settingsXmlFilePath;
        this.globalSettingsXmlFilePath = globalSettingsXmlFilePath;
        this.mavenRepositoryDirectoryPath = mavenRepositoryDirectoryPath;
        this.offlineMode = offlineMode;
        this.forcePolicyUpdate = forcePolicyUpdate;
    }

    public String getSettingsXmlFilePath() {
        return this.settingsXmlFilePath;
    }

    public String getGlobalSettingsXmlFilePath() {
        return this.globalSettingsXmlFilePath;
    }

    public String getMavenRepositoryDirectoryPath() {
        return this.mavenRepositoryDirectoryPath;
    }

    public Boolean getOfflineMode() {
        return this.offlineMode;
    }

    public Boolean getForcePolicyUpdate() {
        return this.forcePolicyUpdate;
    }

    public static class MavenConfigurationBuilder {
        private String settingsXmlFilePath;
        private String globalSettingsXmlFilePath;
        private String mavenRepositoryDirectoryPath;
        private Boolean offlineMode = Boolean.FALSE;
        private Boolean forcePolicyUpdate = Boolean.FALSE;

        public MavenConfigurationBuilder withSettingsXmlFilePath(String settingsXmlFilePath) {
            this.settingsXmlFilePath = settingsXmlFilePath;
            return this;
        }

        public MavenConfigurationBuilder withGlobalSettingsXmlFilePath(String globalSettingsXmlFilePath) {
            this.globalSettingsXmlFilePath = globalSettingsXmlFilePath;
            return this;
        }

        public MavenConfigurationBuilder withMavenRepositoryDirectoryPath(String mavenRepositoryDirectoryPath) {
            this.mavenRepositoryDirectoryPath = mavenRepositoryDirectoryPath;
            return this;
        }

        public MavenConfigurationBuilder withForcePolicyUpdate(Boolean forcePolicyUpdate) {
            this.forcePolicyUpdate = forcePolicyUpdate;
            return this;
        }

        public MavenConfigurationBuilder withOfflineMode(Boolean offlineMode) {
            this.offlineMode = offlineMode;
            return this;
        }

        public MavenConfiguration build() {
            return new MavenConfiguration(this.settingsXmlFilePath, this.globalSettingsXmlFilePath, this.mavenRepositoryDirectoryPath, this.forcePolicyUpdate, this.offlineMode);
        }
    }
}

