/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.classloading;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ClassLoaderUtils
extends ClassLoader {
    public static final String META_INF = "META-INF";
    public static final String MANIFEST_MF = "MANIFEST.MF";
    public static final String CLASS_PATH_MANIFEST_ATTR = "Class-Path";
    public static final String STARTER_JAR_FILE_NAME = "munit.classloader.starter.jar.file.name";

    public List<String> getClassPath() {
        ArrayList<String> classpath = new ArrayList<String>();
        try {
            List<URL> systemUrls = this.getSystemClassLoaderURLs();
            List<URL> projectUrls = this.buildProjectClassPathFromManifest();
            systemUrls.stream().map(u -> u.getPath()).forEach(u -> classpath.add((String)u));
            projectUrls.stream().map(u -> u.getPath()).forEach(u -> classpath.add((String)u));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return classpath;
    }

    private List<URL> getSystemClassLoaderURLs() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ClassLoader sysCl = Thread.currentThread().getContextClassLoader();
        Class<URLClassLoader> refClass = URLClassLoader.class;
        Method methodAddUrl = refClass.getDeclaredMethod("getURLs", new Class[0]);
        methodAddUrl.setAccessible(true);
        URL[] sysClUrls = (URL[])methodAddUrl.invoke((Object)sysCl, new Object[0]);
        return Arrays.asList(sysClUrls);
    }

    public void enhanceClassLoader() {
        try {
            this.addUrlsToClassPath(this.buildProjectClassPathFromManifest());
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void addUrlsToClassPath(List<URL> urls) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ClassLoader sysCl = Thread.currentThread().getContextClassLoader();
        Class<URLClassLoader> refClass = URLClassLoader.class;
        Method methodAddUrl = refClass.getDeclaredMethod("addURL", URL.class);
        methodAddUrl.setAccessible(true);
        for (URL url : urls) {
            methodAddUrl.invoke((Object)sysCl, url);
        }
    }

    private List<URL> buildProjectClassPathFromManifest() {
        LinkedHashSet<URL> projectClassPath = new LinkedHashSet<URL>();
        try {
            String manifestJarPath = System.getProperty(STARTER_JAR_FILE_NAME) + "!/" + META_INF + "/" + MANIFEST_MF;
            ArrayList<URL> resources = Collections.list(Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF"));
            URL manifestURL = resources.stream().filter(resource -> resource.getFile().endsWith(manifestJarPath)).findFirst().get();
            this.addToProjectClasspath(manifestURL, projectClassPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ArrayList<URL>(projectClassPath);
    }

    private void addToProjectClasspath(URL resourceUrl, HashSet<URL> projectClassPath) throws IOException {
        Manifest manifest = new Manifest(resourceUrl.openStream());
        String classpath = (String)manifest.getMainAttributes().get(new Attributes.Name(CLASS_PATH_MANIFEST_ATTR));
        Arrays.asList(classpath.split("file:")).forEach(path -> this.addToSetOfUrls((String)path, projectClassPath));
    }

    private void addToSetOfUrls(String path, HashSet<URL> urls) {
        try {
            urls.add(new File(URLDecoder.decode(path.trim(), "UTF-8")).toURI().toURL());
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            e.printStackTrace();
        }
    }
}

