/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.api.client;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.munit.common.protocol.listeners.RemoteRunEventListener;
import org.mule.munit.common.protocol.listeners.RunEventListener;
import org.mule.munit.common.protocol.listeners.RunEventListenerContainer;
import org.mule.munit.common.protocol.message.RunMessage;
import org.mule.munit.common.protocol.message.RunMessageParser;
import org.mule.munit.common.protocol.message.TestStatus;

public class RunnerClient {
    public static final Integer RECONNECT_MAX_ATTEMPTS = 3;
    public static final int CONNECTION_SLEEP_MILLIS = 1000;
    private ObjectInputStream in;
    private ObjectOutputStream out;
    private boolean suiteRunning = true;
    private boolean suiteSuccess = true;
    private RunMessageParser parser;

    public RunnerClient(int port, RemoteRunEventListener runnerEventListener) throws IOException {
        Socket requestSocket = this.getSocket(port);
        this.in = new ObjectInputStream(requestSocket.getInputStream());
        this.out = new ObjectOutputStream(requestSocket.getOutputStream());
        this.parser = this.buildParser(runnerEventListener);
    }

    private Socket getSocket(int port) throws IOException {
        Socket requestSocket = null;
        Integer attempts = 0;
        boolean keepConnecting = true;
        while (keepConnecting) {
            try {
                requestSocket = new Socket("localhost", port);
            }
            catch (ConnectException e) {
                if (attempts >= RECONNECT_MAX_ATTEMPTS) {
                    throw e;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    return requestSocket;
                }
                Integer n = attempts;
                Integer n2 = attempts = Integer.valueOf(attempts + 1);
                continue;
            }
            keepConnecting = false;
        }
        return requestSocket;
    }

    public void sendSuiteRunInfo(String runToken, String suite, Set<String> testNames, Set<String> tags) throws IOException {
        this.send(new Gson().toJson((Object)new RunMessage(Integer.valueOf(0), (Map)ImmutableMap.of((Object)"runToken", (Object)runToken, (Object)"munitSuite", (Object)suite, (Object)"testNames", (Object)this.collectionToString(testNames), (Object)"tags", (Object)this.collectionToString(tags)))));
    }

    public boolean receiveAndNotify() throws IOException, ClassNotFoundException {
        do {
            String message = (String)this.in.readObject();
            this.parser.parseAndNotify(message);
        } while (this.suiteRunning);
        return this.suiteSuccess;
    }

    private void finish() {
        this.suiteRunning = false;
    }

    private void suiteFailed() {
        this.suiteSuccess = false;
    }

    private void send(String message) throws IOException {
        this.out.writeObject(message);
        this.out.flush();
    }

    private String collectionToString(Collection<String> collection) {
        return collection == null ? "" : collection.stream().collect(Collectors.joining(","));
    }

    private RunMessageParser buildParser(RemoteRunEventListener runnerEventListener) {
        RunEventListenerContainer runnerEventListenerContainer = new RunEventListenerContainer();
        runnerEventListenerContainer.addNotificationListener((RunEventListener)runnerEventListener);
        runnerEventListenerContainer.addNotificationListener((RunEventListener)new SuiteFinishedListener());
        runnerEventListenerContainer.addNotificationListener((RunEventListener)new SuiteFailedListener());
        return new RunMessageParser((RunEventListener)runnerEventListenerContainer);
    }

    private class SuiteFailedListener
    implements RunEventListener {
        private SuiteFailedListener() {
        }

        public void notifyTestEnd(String name, String stackTrace, TestStatus status, long elapsedTime) {
            this.handleStatus(status);
        }

        public void notifyBeforeSuiteEnd(String name, String stackTrace, TestStatus status) {
            this.handleStatus(status);
        }

        public void notifyAfterSuiteEnd(String name, String stackTrace, TestStatus status) {
            this.handleStatus(status);
        }

        public void notifyUnexpectedError(String stackTrace) {
            this.handleStatus(TestStatus.ERROR);
        }

        public void notifySuiteUnexpectedError(String name, String stackTrace) {
            this.handleStatus(TestStatus.ERROR);
        }

        private void handleStatus(TestStatus status) {
            if (TestStatus.FAILURE.equals((Object)status) || TestStatus.ERROR.equals((Object)status)) {
                RunnerClient.this.suiteFailed();
            }
        }
    }

    private class SuiteFinishedListener
    implements RunEventListener {
        private SuiteFinishedListener() {
        }

        public void notifySuiteUnexpectedError(String name, String stackTrace) {
            this.notifyUnexpectedError(stackTrace);
        }

        public void notifySuiteEnd(String suite, long elapsedTime) {
            RunnerClient.this.finish();
        }

        public void notifyUnexpectedError(String stackTrace) {
            RunnerClient.this.finish();
        }
    }
}

