/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang3.StringUtils;

public class DomainStructureGenerator {
    private Boolean exploded;
    private Path domainJarFilePath;
    private Path destinationFolderPath;

    public DomainStructureGenerator(Path domainJarFilePath, Path destinationFolder, String domainName) {
        this(domainJarFilePath, destinationFolder, domainName, false);
    }

    public DomainStructureGenerator(Path domainJarFilePath, Path destinationFolder, String domainName, Boolean exploded) {
        Preconditions.checkArgument((domainJarFilePath != null ? 1 : 0) != 0, (Object)"The domain jar file must not be null");
        Preconditions.checkArgument((destinationFolder != null ? 1 : 0) != 0, (Object)"The destination folder must not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)domainName), (Object)"The application name must not be null nor empty");
        this.exploded = exploded;
        this.domainJarFilePath = domainJarFilePath;
        this.destinationFolderPath = destinationFolder.resolve(domainName);
    }

    public Path generate() throws Exception {
        this.destinationFolderPath.toFile().mkdirs();
        if (this.exploded.booleanValue()) {
            return this.createExplodedPackage();
        }
        return this.createJarPackaged();
    }

    private Path createJarPackaged() throws Exception {
        return Files.copy(this.domainJarFilePath, this.destinationFolderPath.resolve(this.domainJarFilePath.getFileName()), new CopyOption[0]);
    }

    private Path createExplodedPackage() throws Exception {
        JarFile domainJarFile = new JarFile(this.domainJarFilePath.toFile());
        Enumeration<JarEntry> enumEntries = domainJarFile.entries();
        while (enumEntries.hasMoreElements()) {
            JarEntry file = enumEntries.nextElement();
            File f = new File(this.destinationFolderPath.toFile().getCanonicalPath() + File.separator + file.getName());
            if (file.isDirectory()) {
                f.mkdir();
                continue;
            }
            InputStream is = domainJarFile.getInputStream(file);
            FileOutputStream fos = new FileOutputStream(f);
            while (is.available() > 0) {
                fos.write(is.read());
            }
            fos.close();
            is.close();
        }
        domainJarFile.close();
        return this.destinationFolderPath;
    }
}

