/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
/*
* Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
* copyright law. All use of this software is subject to MuleSoft's Master Subscription
* Agreement (or other master license agreement) separately entered into in writing between
* you and MuleSoft. If such an agreement is not in place, you may not use the software.
*/

package org.mule.munit.remote.api.configuration;

import java.util.ArrayList;
import java.util.List;

/**
 * Defines the Container configuration
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class ContainerConfiguration {

  private String runtimeId;
  private String product;
  private String munitWorkingDirectoryPath;
  private String log4JConfigurationFilePath;
  private MavenConfiguration mavenConfiguration;
  private List<ServerPluginConfiguration> serverPluginConfigurations;

  protected ContainerConfiguration(String runtimeId, String product, String munitWorkingDirectoryPath,
                                   String log4JConfigurationFilePath, MavenConfiguration mavenConfiguration,
                                   List<ServerPluginConfiguration> serverPluginConfigurations) {
    this.runtimeId = runtimeId;
    this.product = product;
    this.munitWorkingDirectoryPath = munitWorkingDirectoryPath;
    this.log4JConfigurationFilePath = log4JConfigurationFilePath;
    this.mavenConfiguration = mavenConfiguration;
    this.serverPluginConfigurations = serverPluginConfigurations;
  }

  public String getRuntimeId() {
    return runtimeId;
  }

  public String getProduct() {
    return product;
  }

  public String getMunitWorkingDirectoryPath() {
    return munitWorkingDirectoryPath;
  }

  public String getLog4JConfigurationFilePath() {
    return log4JConfigurationFilePath;
  }

  public MavenConfiguration getMavenConfiguration() {
    return mavenConfiguration;
  }

  public List<ServerPluginConfiguration> getServerPluginConfigurations() {
    return serverPluginConfigurations;
  }

  /**
   * Container Configuration Builder
   *
   * @author Mulesoft Inc.
   * @since 2.0.0
   */
  public static class ContainerConfigurationBuilder {

    private String runtimeId;
    private String product;
    private String munitWorkingDirectoryPath;
    private String log4JConfigurationFilePath;
    private MavenConfiguration mavenConfiguration;
    private List<ServerPluginConfiguration> serverPluginConfigurations = new ArrayList<>();

    public static ContainerConfigurationBuilder from(ContainerConfiguration cc) {
      ContainerConfigurationBuilder builder = new ContainerConfigurationBuilder();

      builder.withLog4JConfigurationFilePath(cc.getLog4JConfigurationFilePath());
      builder.withMavenConfiguration(cc.getMavenConfiguration());
      cc.getServerPluginConfigurations().forEach(spc -> builder.withServerPluginConfiguration(spc));
      builder.withProduct(cc.getProduct());
      builder.withRuntimeId(cc.getRuntimeId());
      builder.withMunitWorkingDirectoryPath(cc.getMunitWorkingDirectoryPath());
      return builder;
    }

    public ContainerConfigurationBuilder withRuntimeId(String runtimeId) {
      this.runtimeId = runtimeId;
      return this;
    }

    public ContainerConfigurationBuilder withMunitWorkingDirectoryPath(String munitWorkingDirectoryPath) {
      this.munitWorkingDirectoryPath = munitWorkingDirectoryPath;
      return this;
    }

    public ContainerConfigurationBuilder withLog4JConfigurationFilePath(String log4JConfigurationFilePath) {
      this.log4JConfigurationFilePath = log4JConfigurationFilePath;
      return this;
    }

    public ContainerConfigurationBuilder withMavenConfiguration(MavenConfiguration mavenConfiguration) {
      this.mavenConfiguration = mavenConfiguration;
      return this;
    }

    public ContainerConfigurationBuilder withProduct(String product) {
      this.product = product;
      return this;
    }

    public ContainerConfigurationBuilder withServerPluginConfiguration(ServerPluginConfiguration serverPluginConfiguration) {
      this.serverPluginConfigurations.add(serverPluginConfiguration);
      return this;
    }

    public ContainerConfiguration build() {
      return new ContainerConfiguration(runtimeId, product, munitWorkingDirectoryPath, log4JConfigurationFilePath,
                                        mavenConfiguration, serverPluginConfigurations);
    }
  }

}
