/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.notifiers;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;

import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.protocol.notifiers.RunMessageNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * The goal of this class is to notify through a socket all events received though the interface {@link RunMessageNotifier}
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class SocketNotifier extends RunMessageNotifier {

  private transient Logger logger = LoggerFactory.getLogger(this.getClass());

  private String host;
  private Integer port;
  private ObjectOutputStream out;

  public void init() throws Exception {
    String socketHost = StringUtils.isEmpty(host) ? "localhost" : host;
    Socket requestSocket = new Socket(socketHost, port);
    out = new ObjectOutputStream(requestSocket.getOutputStream());
    logger.info("Connected to localhost on port " + port);
  }

  public void setHost(String host) {
    this.host = host;
  }

  public void setPort(String port) {
    this.port = Integer.valueOf(port);
  }

  @Override
  public void sendMessage(String message) {
    try {
      out.writeObject(message);
      out.flush();
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }

}
