/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.api.project;

import java.nio.file.Path;

/**
 * It create a exploded application structure (lightweight) containing all the required folders and files. The exploded
 * application contains the test resources.
 *
 * @author Mulesoft Inc.
 * @since 2.2.0
 */
public interface ApplicationStructureGenerator {

  /**
   * Generates an exploded test package
   *
   * @return the path to the generated structure
   * @throws Exception in case of failure
   */
  Path generate(Path destinationFolder) throws Exception;

}
