/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.properties;

import java.util.Map;

/**
 * A suite to be run with different parameters
 *
 * @author Mulesoft Inc.
 * @since 2.2.0
 */
public class ParameterizedSuite {

  private String suitePath;
  private String parameterizationName;
  private Map<String, String> parameters;

  public ParameterizedSuite(String suitePath, String parameterizationName, Map<String, String> parameters) {
    this.suitePath = suitePath;
    this.parameterizationName = parameterizationName;
    this.parameters = parameters;
  }

  public String getParameterizationName() {
    return parameterizationName;
  }

  public Map<String, String> getParameters() {
    return parameters;
  }

  public String getSuitePath() {
    return suitePath;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    ParameterizedSuite that = (ParameterizedSuite) o;

    if (!suitePath.equals(that.suitePath)) {
      return false;
    }
    if (!parameterizationName.equals(that.parameterizationName)) {
      return false;
    }
    return parameters.equals(that.parameters);
  }

  @Override
  public int hashCode() {
    int result = suitePath.hashCode();
    result = 31 * result + parameterizationName.hashCode();
    result = 31 * result + parameters.hashCode();
    return result;
  }
}
