/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.properties;

import java.io.File;
import java.util.HashSet;
import java.util.Set;

/**
 * Locates parameterized and non-parameterized suites in an application
 *
 * @author Mulesoft Inc.
 * @since 2.2.0
 */
public class ParameterizedSuitesLocator {

  private Set<String> suitePaths;
  private File appLocation;
  private Set<String> nonParameterizedSuites;
  private Set<ParameterizedSuite> parameterizedSuites;

  public ParameterizedSuitesLocator(File appLocation, Set<String> suitePaths) {
    this.appLocation = appLocation;
    this.suitePaths = suitePaths;
    this.nonParameterizedSuites = new HashSet<>();
    this.parameterizedSuites = new HashSet<>();
    locateParameterizedSuites();
  }

  private void locateParameterizedSuites() {
    for (String suitePath : suitePaths) {
      File suite = new File(appLocation, suitePath);
      Set<ParameterizedSuite> locatedParameterizedSuites = ParameterizedSuiteParser.parseParameterizations(suite, suitePath);
      if (locatedParameterizedSuites.isEmpty()) {
        nonParameterizedSuites.add(suitePath);
      } else {
        parameterizedSuites.addAll(locatedParameterizedSuites);
      }
    }
  }

  public Set<ParameterizedSuite> parameterizedSuites() {
    return parameterizedSuites;
  }

  public Set<String> nonParameterizedSuites() {
    return nonParameterizedSuites;
  }

}
