/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.properties;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

import org.mule.munit.common.properties.MUnitUserPropertiesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Sets a system property with a temporary directory location
 *
 * @author Mulesoft Inc.
 * @since 2.2.0
 */
public class TemporaryFolderConfigurator {

  protected static final String MUNIT_TEMP_DIR_PROPERTY = "munit.temporary.directory";
  protected static final String MUNIT_TEMP_DIR_PREFIX = "munit-temp-dir";
  protected static final transient Logger logger = LoggerFactory.getLogger(TemporaryFolderConfigurator.class);

  public static void loadTemporaryDirectoryProperty() {
    try {
      Path temporaryDirectory = Files.createTempDirectory(MUNIT_TEMP_DIR_PREFIX);
      MUnitUserPropertiesManager.addUserPropertyToSystem(MUNIT_TEMP_DIR_PROPERTY, temporaryDirectory.toString());
      logger.debug("Setting {} property to {}", MUNIT_TEMP_DIR_PROPERTY, temporaryDirectory);
    } catch (IOException e) {
      logger.error("Unable to create temporary folder", e);
    }
  }

}
