/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.container;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.exception.DeploymentException;
import org.mule.munit.remote.exception.DeploymentExceptionThrower;
import org.mule.munit.remote.properties.TemporaryFolderConfigurator;
import org.mule.runtime.module.embedded.api.ArtifactConfiguration;
import org.mule.runtime.module.embedded.api.DeploymentConfiguration;
import org.mule.runtime.module.embedded.api.DeploymentService;
import org.mule.runtime.module.embedded.api.EmbeddedContainer;

public class ContainerManager {
    private EmbeddedContainer container;
    private RunConfiguration runConfiguration;
    private DeploymentConfiguration deploymentConfiguration;

    public ContainerManager(EmbeddedContainer container, RunConfiguration runConfiguration, DeploymentConfiguration deploymentConfiguration) {
        this.container = container;
        this.runConfiguration = runConfiguration;
        this.deploymentConfiguration = deploymentConfiguration;
    }

    public void deployDomain() throws DeploymentException {
        String domainLocation = this.runConfiguration.getDomainLocation();
        if (StringUtils.isNotBlank((CharSequence)domainLocation)) {
            Path artifactLocation = Paths.get(domainLocation, new String[0]);
            ArtifactConfiguration artifactConfiguration = this.getArtifactConfiguration(artifactLocation, this.deploymentConfiguration);
            DeploymentService deploymentService = this.container.getDeploymentService();
            try {
                deploymentService.deployDomain(artifactConfiguration);
            }
            catch (RuntimeException e) {
                DeploymentExceptionThrower.throwIfMatches(e);
            }
        }
    }

    public void deployApplication() throws DeploymentException {
        String applicationName = this.runConfiguration.getProjectName();
        String munitWorkingDirectoryPath = this.runConfiguration.getContainerConfiguration().getMunitWorkingDirectoryPath();
        Path artifactLocation = Paths.get(munitWorkingDirectoryPath, applicationName);
        ArtifactConfiguration artifactConfiguration = this.getArtifactConfiguration(artifactLocation, this.deploymentConfiguration);
        DeploymentService deploymentService = this.container.getDeploymentService();
        TemporaryFolderConfigurator.loadTemporaryDirectoryProperty();
        try {
            deploymentService.deployApplication(artifactConfiguration);
        }
        catch (RuntimeException e) {
            DeploymentExceptionThrower.throwIfMatches(e);
        }
    }

    public void undeployApplication() {
        this.container.getDeploymentService().undeployApplication(this.runConfiguration.getProjectName());
    }

    private ArtifactConfiguration getArtifactConfiguration(Path artifactLocation, DeploymentConfiguration deploymentConfiguration) {
        return ArtifactConfiguration.builder().deploymentConfiguration(deploymentConfiguration).artifactLocation(artifactLocation.toFile()).build();
    }
}

