/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.container;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.mule.munit.common.properties.MUnitUserPropertiesManager;
import org.mule.munit.common.protocol.listeners.RemoteRunEventListener;
import org.mule.munit.common.util.StackTraceUtil;
import org.mule.munit.remote.api.client.RunnerClient;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.container.ContainerManager;
import org.mule.munit.remote.exception.DeploymentException;
import org.mule.munit.remote.properties.ParameterizedSuite;
import org.mule.munit.remote.properties.ParameterizedSuitesLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuiteRunDispatcher {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(SuiteRunDispatcher.class);
    private ContainerManager containerManager;
    private RunConfiguration runConfig;
    private Integer munitRunnerPort;
    private ParameterizedSuitesLocator parameterizedSuitesLocator;

    public SuiteRunDispatcher(ContainerManager containerManager, Integer munitRunnerPort, RunConfiguration runConfiguration) {
        this.containerManager = containerManager;
        this.runConfig = runConfiguration;
        this.munitRunnerPort = munitRunnerPort;
        File appLocation = new File(runConfiguration.getContainerConfiguration().getMunitWorkingDirectoryPath(), runConfiguration.getProjectName());
        this.parameterizedSuitesLocator = new ParameterizedSuitesLocator(appLocation, this.runConfig.getAllSuitePaths());
    }

    public void runSuites(RemoteRunEventListener listener) throws DeploymentException {
        try {
            this.runParameterizedSuites(this.parameterizedSuitesLocator.parameterizedSuites(), listener);
            this.runNonParameterizedSuites(this.parameterizedSuitesLocator.nonParameterizedSuites(), listener);
        }
        catch (SkipAfterFailureException e) {
            LOGGER.debug("Skipped running suites since skipAfterFailure is on");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runParameterizedSuites(Collection<ParameterizedSuite> parameterizedSuites, RemoteRunEventListener listener) throws SkipAfterFailureException {
        this.setInitialProperties(parameterizedSuites);
        for (ParameterizedSuite suite : parameterizedSuites) {
            if (!this.shouldRunSuite(suite.getSuitePath())) continue;
            MUnitUserPropertiesManager.addUserPropertiesToSystem(suite.getParameters());
            try {
                this.containerManager.deployApplication();
                boolean success = this.runSuite(this.runConfig, listener, suite.getSuitePath(), suite.getParameterizationName());
                if (success || !this.runConfig.isSkipAfterFailure().booleanValue()) continue;
                throw new SkipAfterFailureException();
            }
            catch (DeploymentException e) {
                listener.notifyContainerFailure(suite.getSuitePath(), suite.getParameterizationName(), StackTraceUtil.getStackTrace((Throwable)e));
            }
            finally {
                this.containerManager.undeployApplication();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runNonParameterizedSuites(Set<String> suitePaths, RemoteRunEventListener listener) throws DeploymentException, SkipAfterFailureException {
        if (suitePaths.isEmpty() || Collections.disjoint(suitePaths, this.runConfig.getSuitePaths())) {
            return;
        }
        this.containerManager.deployApplication();
        try {
            for (String suitePath : suitePaths) {
                boolean success;
                if (!this.shouldRunSuite(suitePath) || (success = this.runSuite(this.runConfig, listener, suitePath, "")) || !this.runConfig.isSkipAfterFailure().booleanValue()) continue;
                throw new SkipAfterFailureException();
            }
        }
        finally {
            this.containerManager.undeployApplication();
        }
    }

    private boolean runSuite(RunConfiguration runConfig, RemoteRunEventListener listener, String suitePath, String parameterizationName) {
        try {
            RunnerClient runnerClient = this.getRunnerClient(listener);
            runnerClient.sendSuiteRunInfo(runConfig.getRunToken(), suitePath, parameterizationName, runConfig.getTestNames(), runConfig.getTags());
            return runnerClient.receiveAndNotify();
        }
        catch (IOException | ClassNotFoundException | RuntimeException e) {
            listener.notifyContainerFailure(suitePath, parameterizationName, StackTraceUtil.getStackTrace((Throwable)e));
            return false;
        }
    }

    protected RunnerClient getRunnerClient(RemoteRunEventListener listener) throws IOException {
        return new RunnerClient(this.munitRunnerPort, listener);
    }

    private boolean shouldRunSuite(String suitePath) {
        return this.runConfig.getSuitePaths().contains(suitePath);
    }

    private void setInitialProperties(Collection<ParameterizedSuite> parameterizedSuites) {
        parameterizedSuites.forEach(suite -> MUnitUserPropertiesManager.addUserPropertiesToSystem(suite.getParameters()));
    }

    private class SkipAfterFailureException
    extends Exception {
        private SkipAfterFailureException() {
        }
    }
}

