/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.properties;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.mule.munit.remote.properties.ParameterizedSuite;

public class ParameterizedSuiteParser {
    private static final Namespace MUNIT_NAMESPACE = Namespace.getNamespace((String)"munit", (String)"http://www.mulesoft.org/schema/mule/munit");
    private static final String CONFIG_NAME = "config";
    private static final String PARAMETERIZATIONS_NAME = "parameterizations";
    private static final String PARAMETERIZATION_NAME = "parameterization";
    private static final String PARAMETERS_NAME = "parameters";
    private static final String PARAMETER_NAME = "parameter";
    private static final String PROPERTY_NAME_NAME = "propertyName";
    private static final String VALUE_NAME = "value";
    private static final String NAME_NAME = "name";

    public static Set<ParameterizedSuite> parseParameterizations(File suiteFile, String suitePath) {
        try {
            SAXBuilder saxBuilder = new SAXBuilder();
            Document document = saxBuilder.build(suiteFile);
            Element rootElement = document.getRootElement();
            Element config = rootElement.getChild(CONFIG_NAME, MUNIT_NAMESPACE);
            if (config == null) {
                return Collections.emptySet();
            }
            Element parameterizations = config.getChild(PARAMETERIZATIONS_NAME, MUNIT_NAMESPACE);
            if (parameterizations == null) {
                return Collections.emptySet();
            }
            return ParameterizedSuiteParser.collectParameterizedSuites(parameterizations.getChildren(PARAMETERIZATION_NAME, MUNIT_NAMESPACE), suitePath);
        }
        catch (IOException | JDOMException e) {
            return Collections.emptySet();
        }
    }

    private static Set<ParameterizedSuite> collectParameterizedSuites(List<Element> parameterizations, String suitePath) {
        HashSet<ParameterizedSuite> parameterizedSuites = new HashSet<ParameterizedSuite>();
        for (Element parameterization : parameterizations) {
            HashMap<String, String> parametersMap = new HashMap<String, String>();
            Element parameters = parameterization.getChild(PARAMETERS_NAME, MUNIT_NAMESPACE);
            if (parameters != null) {
                List parameterChildren = parameters.getChildren(PARAMETER_NAME, MUNIT_NAMESPACE);
                for (Element parameter : parameterChildren) {
                    parametersMap.put(parameter.getAttributeValue(PROPERTY_NAME_NAME), parameter.getAttributeValue(VALUE_NAME));
                }
            }
            String name = parameterization.getAttributeValue(NAME_NAME);
            parameterizedSuites.add(new ParameterizedSuite(suitePath, name, parametersMap));
        }
        return parameterizedSuites;
    }
}

