/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.properties;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.mule.munit.remote.properties.ParameterizedSuite;
import org.mule.munit.remote.properties.ParameterizedSuiteParser;

public class ParameterizedSuitesLocator {
    private Set<String> suitePaths;
    private File appLocation;
    private Set<String> nonParameterizedSuites;
    private Set<ParameterizedSuite> parameterizedSuites;

    public ParameterizedSuitesLocator(File appLocation, Set<String> suitePaths) {
        this.appLocation = appLocation;
        this.suitePaths = suitePaths;
        this.nonParameterizedSuites = new HashSet<String>();
        this.parameterizedSuites = new HashSet<ParameterizedSuite>();
        this.locateParameterizedSuites();
    }

    private void locateParameterizedSuites() {
        for (String suitePath : this.suitePaths) {
            File suite = new File(this.appLocation, suitePath);
            Set<ParameterizedSuite> locatedParameterizedSuites = ParameterizedSuiteParser.parseParameterizations(suite, suitePath);
            if (locatedParameterizedSuites.isEmpty()) {
                this.nonParameterizedSuites.add(suitePath);
                continue;
            }
            this.parameterizedSuites.addAll(locatedParameterizedSuites);
        }
    }

    public Set<ParameterizedSuite> parameterizedSuites() {
        return this.parameterizedSuites;
    }

    public Set<String> nonParameterizedSuites() {
        return this.nonParameterizedSuites;
    }
}

