/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.properties;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.mule.munit.common.properties.MUnitUserPropertiesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryFolderConfigurator {
    protected static final String MUNIT_TEMP_DIR_PROPERTY = "munit.temporary.directory";
    protected static final String MUNIT_TEMP_DIR_PREFIX = "munit-temp-dir";
    protected static final transient Logger logger = LoggerFactory.getLogger(TemporaryFolderConfigurator.class);

    public static void loadTemporaryDirectoryProperty() {
        try {
            Path temporaryDirectory = Files.createTempDirectory(MUNIT_TEMP_DIR_PREFIX, new FileAttribute[0]);
            MUnitUserPropertiesManager.addUserPropertyToSystem((String)MUNIT_TEMP_DIR_PROPERTY, (String)temporaryDirectory.toString());
            logger.debug("Setting {} property to {}", (Object)MUNIT_TEMP_DIR_PROPERTY, (Object)temporaryDirectory);
        }
        catch (IOException e) {
            logger.error("Unable to create temporary folder", (Throwable)e);
        }
    }
}

