/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.properties;

import static org.mule.munit.common.util.VersionUtils.isAtLeastMinMuleVersion;

import org.mule.munit.remote.api.configuration.RunConfiguration;

/**
 * Sets the default processing strategy property to the implementation used by Mule Flows.
 * 
 * This should be removed with MU-1566
 * 
 * @since 2.2.0
 * @author Mulesoft Inc.
 */
public class ProcessingStrategyFactoryConfigurator {

  protected static final String PROCESSING_STRATEGY_FACTORY =
      "org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory";
  protected static final String PROCESSING_STRATEGY_FACTORY_IMPL =
      "org.mule.runtime.core.internal.processor.strategy.TransactionAwareProactorStreamEmitterProcessingStrategyFactory";
  protected static final String PROCESSING_STRATEGY_MIN_VERSION = "4.2.0";

  public static void setFactoryProperty(RunConfiguration runConfiguration) {
    String runtimeVersion = runConfiguration.getContainerConfiguration().getRuntimeId();
    if (System.getProperty(PROCESSING_STRATEGY_FACTORY) == null) {
      if (isAtLeastMinMuleVersion(runtimeVersion, PROCESSING_STRATEGY_MIN_VERSION)) {
        System.setProperty(PROCESSING_STRATEGY_FACTORY, PROCESSING_STRATEGY_FACTORY_IMPL);
      }
    }
  }
}
