/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.container;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.exception.DeploymentException;
import org.mule.munit.remote.exception.DeploymentExceptionThrower;
import org.mule.munit.remote.properties.ProcessingStrategyFactoryConfigurator;
import org.mule.munit.remote.properties.TemporaryFolderConfigurator;
import org.mule.runtime.module.embedded.api.ArtifactConfiguration;
import org.mule.runtime.module.embedded.api.DeploymentConfiguration;
import org.mule.runtime.module.embedded.api.DeploymentService;
import org.mule.runtime.module.embedded.api.EmbeddedContainer;

public class ContainerManager {
    public static final String MUNIT_DISABLE_LAZY_CONNECTIONS = "munit.disable.lazy.connections";
    public static final String MUNIT_DISABLE_LAZY_INITIALIZATION = "munit.disable.lazy.initialization";
    private EmbeddedContainer container;
    private RunConfiguration runConfiguration;

    public ContainerManager(EmbeddedContainer container, RunConfiguration runConfiguration) {
        this.container = container;
        this.runConfiguration = runConfiguration;
    }

    public void deployDomain() throws DeploymentException {
        String domainLocation = this.runConfiguration.getDomainLocation();
        if (StringUtils.isNotBlank((CharSequence)domainLocation)) {
            Path artifactLocation = Paths.get(domainLocation, new String[0]);
            ArtifactConfiguration artifactConfiguration = this.getArtifactConfiguration(artifactLocation, this.buildDeploymentConfiguration(true));
            DeploymentService deploymentService = this.container.getDeploymentService();
            try {
                deploymentService.deployDomain(artifactConfiguration);
            }
            catch (RuntimeException e) {
                DeploymentExceptionThrower.throwIfMatches(e);
            }
        }
    }

    public void deployApplication(boolean xmlValidations) throws DeploymentException {
        String applicationName = this.runConfiguration.getProjectName();
        String munitWorkingDirectoryPath = this.runConfiguration.getContainerConfiguration().getMunitWorkingDirectoryPath();
        Path artifactLocation = Paths.get(munitWorkingDirectoryPath, applicationName);
        ArtifactConfiguration artifactConfiguration = this.getArtifactConfiguration(artifactLocation, this.buildDeploymentConfiguration(xmlValidations));
        DeploymentService deploymentService = this.container.getDeploymentService();
        TemporaryFolderConfigurator.loadTemporaryDirectoryProperty();
        ProcessingStrategyFactoryConfigurator.setFactoryProperty(this.runConfiguration);
        try {
            deploymentService.deployApplication(artifactConfiguration);
        }
        catch (RuntimeException e) {
            DeploymentExceptionThrower.throwIfMatches(e);
        }
    }

    public void undeployApplication() {
        this.container.getDeploymentService().undeployApplication(this.runConfiguration.getProjectName());
    }

    private ArtifactConfiguration getArtifactConfiguration(Path artifactLocation, DeploymentConfiguration deploymentConfiguration) {
        return ArtifactConfiguration.builder().deploymentConfiguration(deploymentConfiguration).artifactLocation(artifactLocation.toFile()).build();
    }

    protected DeploymentConfiguration buildDeploymentConfiguration(boolean enableXmlValidations) {
        return DeploymentConfiguration.builder().lazyConnectionsEnabled(this.enableLazyConnections().booleanValue()).lazyInitialization(this.enableLazyInitialization().booleanValue()).xmlValidations(enableXmlValidations).build();
    }

    private Boolean enableLazyConnections() {
        if (Boolean.valueOf(System.getProperty(MUNIT_DISABLE_LAZY_CONNECTIONS, "false")).booleanValue()) {
            return false;
        }
        return true;
    }

    private Boolean enableLazyInitialization() {
        if (Boolean.valueOf(System.getProperty(MUNIT_DISABLE_LAZY_INITIALIZATION, "false")).booleanValue()) {
            return false;
        }
        return true;
    }
}

