/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.container;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.munit.common.properties.MUnitUserPropertiesManager;
import org.mule.munit.common.protocol.listeners.RemoteRunEventListener;
import org.mule.munit.common.util.FileUtils;
import org.mule.munit.common.util.IOUtils;
import org.mule.munit.common.util.StackTraceUtil;
import org.mule.munit.common.util.VersionUtils;
import org.mule.munit.remote.FolderNames;
import org.mule.munit.remote.api.client.RunnerClient;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.container.ContainerManager;
import org.mule.munit.remote.container.model.SuiteDeployment;
import org.mule.munit.remote.container.model.SuiteRun;
import org.mule.munit.remote.exception.DeploymentException;
import org.mule.munit.remote.properties.Parameterization;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuiteRunDispatcher {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(SuiteRunDispatcher.class);
    private ContainerManager containerManager;
    private RunConfiguration runConfig;
    private Integer munitRunnerPort;
    private MuleApplicationModel originalMuleApplicationModel;
    private Set<SuiteRun> suiteRuns;

    public SuiteRunDispatcher(ContainerManager containerManager, Integer munitRunnerPort, RunConfiguration runConfiguration, Set<SuiteRun> suiteRuns) {
        this.containerManager = containerManager;
        this.runConfig = runConfiguration;
        this.munitRunnerPort = munitRunnerPort;
        this.suiteRuns = suiteRuns;
        this.originalMuleApplicationModel = this.getOriginalApplicationModel();
    }

    private MuleApplicationModel getOriginalApplicationModel() {
        try {
            File muleArtifactJsonFile = this.getMuleArtifactJsonFile();
            return (MuleApplicationModel)new MuleApplicationModelJsonSerializer().deserialize(IOUtils.toString((URI)muleArtifactJsonFile.toURI(), (Charset)Charset.defaultCharset()));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private File getMuleArtifactJsonFile() {
        File applicationDirectory = new File(this.runConfig.getContainerConfiguration().getMunitWorkingDirectoryPath(), this.runConfig.getProjectName());
        return Paths.get(applicationDirectory.toURI()).resolve(FolderNames.META_INF.value()).resolve(FolderNames.MULE_ARTIFACT.value()).resolve("mule-artifact.json").toFile();
    }

    public void runSuites(RemoteRunEventListener listener) throws DeploymentException {
        try {
            Collection<SuiteDeployment> suiteDeployments = this.generateSuiteDeployments();
            this.setInitialProperties(suiteDeployments);
            for (SuiteDeployment suiteDeployment : suiteDeployments) {
                this.performSuiteDeploy(listener, suiteDeployment);
            }
        }
        catch (SkipAfterFailureException e) {
            LOGGER.debug("Skipped running suites since skipAfterFailure is on");
        }
    }

    private Collection<SuiteDeployment> generateSuiteDeployments() {
        ArrayList<SuiteDeployment> suiteDeployments = new ArrayList<SuiteDeployment>();
        suiteDeployments.addAll(this.getParameterizedDeployments());
        this.getDesignTimeSuitesDeployment().ifPresent(suiteDeployments::add);
        this.getRuntimeSuitesDeployment().ifPresent(suiteDeployments::add);
        return suiteDeployments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSuiteDeploy(RemoteRunEventListener listener, SuiteDeployment suiteDeployment) throws SkipAfterFailureException {
        Set<SuiteRun> suiteRuns = suiteDeployment.getSuiteRuns();
        if (suiteRuns.stream().noneMatch(this::shouldRunSuite)) {
            LOGGER.info("Suite run for suites " + suiteRuns + " will not start since no suites will run");
            return;
        }
        try {
            this.removeXmlInvalidSuites(this.getXmlInvalidSuites(suiteDeployment));
            MUnitUserPropertiesManager.addUserPropertiesToSystem(suiteDeployment.getSystemProperties());
            this.containerManager.deployApplication(suiteDeployment.isEnableXmlValidations());
            for (SuiteRun suiteRun : suiteRuns) {
                if (this.shouldRunSuite(suiteRun)) {
                    String parameterizationName;
                    String suitePath = suiteRun.getSuitePath();
                    boolean success = this.runSuite(this.runConfig, listener, suitePath, parameterizationName = this.getParameterizationName(suiteRun));
                    if (success || !this.runConfig.isSkipAfterFailure().booleanValue()) continue;
                    throw new SkipAfterFailureException();
                }
                this.showSuiteSkippedMessage(suiteRun);
            }
        }
        catch (DeploymentException e) {
            if (suiteRuns.size() > 1) {
                listener.notifyContainerFailure(StackTraceUtil.getStackTrace((Throwable)e));
            } else {
                SuiteRun suiteRun = suiteRuns.iterator().next();
                listener.notifyContainerFailure(suiteRun.getSuitePath(), this.getParameterizationName(suiteRun), StackTraceUtil.getStackTrace((Throwable)e));
            }
        }
        finally {
            this.containerManager.undeployApplication();
        }
    }

    private Set<String> getXmlInvalidSuites(SuiteDeployment suiteDeployment) {
        HashSet<String> xmlInvalidSuites = new HashSet<String>();
        if (suiteDeployment.isEnableXmlValidations()) {
            xmlInvalidSuites.addAll(this.getDesignTimeSuitesPaths());
        }
        xmlInvalidSuites.addAll(suiteDeployment.getSuiteRuns().stream().filter(suiteRun -> !this.shouldRunSuite((SuiteRun)suiteRun)).map(SuiteRun::getSuitePath).collect(Collectors.toList()));
        return xmlInvalidSuites;
    }

    private void removeXmlInvalidSuites(Set<String> invalidXmlSuites) {
        Set newConfigs = this.originalMuleApplicationModel.getConfigs();
        if (!invalidXmlSuites.isEmpty()) {
            newConfigs = newConfigs.stream().filter(config -> !invalidXmlSuites.contains(config)).collect(Collectors.toSet());
        }
        try {
            MuleApplicationModel muleApplicationModel = this.overrideConfigs(this.originalMuleApplicationModel, newConfigs);
            String newMuleApplicationModelString = new MuleApplicationModelJsonSerializer().serialize((AbstractMuleArtifactModel)muleApplicationModel);
            FileUtils.write((File)this.getMuleArtifactJsonFile(), (CharSequence)newMuleApplicationModelString, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new IllegalStateException("An error occurred while regenerating the Mule Application Model", e);
        }
    }

    private void showSuiteSkippedMessage(SuiteRun suiteRun) {
        String message = "Suite " + suiteRun.getSuitePath() + " will not be deployed: ";
        if (suiteRun.isIgnored()) {
            message = message + "Suite is ignored";
        } else if (!this.isCurrentRuntimeAtLeastMinVersion(suiteRun).booleanValue()) {
            message = message + String.format("Current runtime version [%s] is lower that suite's minMuleVersion [%s]", this.getRuntimeVersion(), suiteRun.getMinMuleVersion().orElse("N/A"));
        } else if (!this.isSuiteFiltered(suiteRun)) {
            message = message + "Suite was filtered from running";
        }
        LOGGER.info(message);
    }

    private boolean runSuite(RunConfiguration runConfig, RemoteRunEventListener listener, String suitePath, String parameterizationName) {
        try {
            RunnerClient runnerClient = this.getRunnerClient(listener);
            runnerClient.sendSuiteRunInfo(runConfig.getRunToken(), suitePath, parameterizationName, runConfig.getTestNames(), runConfig.getTags());
            return runnerClient.receiveAndNotify();
        }
        catch (IOException | ClassNotFoundException | RuntimeException e) {
            listener.notifyContainerFailure(suitePath, parameterizationName, StackTraceUtil.getStackTrace((Throwable)e));
            return false;
        }
    }

    protected RunnerClient getRunnerClient(RemoteRunEventListener listener) throws IOException {
        return new RunnerClient(this.munitRunnerPort, listener);
    }

    private boolean shouldRunSuite(SuiteRun suiteRun) {
        return !suiteRun.isIgnored() && this.isCurrentRuntimeAtLeastMinVersion(suiteRun) != false && this.isSuiteFiltered(suiteRun);
    }

    private Boolean isCurrentRuntimeAtLeastMinVersion(SuiteRun suiteRun) {
        return suiteRun.getMinMuleVersion().map(minMuleVersion -> VersionUtils.isAtLeastMinMuleVersion((String)this.getRuntimeVersion(), (String)minMuleVersion)).orElse(true);
    }

    private boolean isSuiteFiltered(SuiteRun suiteRun) {
        return this.runConfig.getSuitePaths().contains(suiteRun.getSuitePath());
    }

    private void setInitialProperties(Collection<SuiteDeployment> suiteDeployments) {
        suiteDeployments.forEach(suite -> MUnitUserPropertiesManager.addUserPropertiesToSystem(suite.getSystemProperties()));
    }

    public MuleApplicationModel overrideConfigs(MuleApplicationModel originalMuleApplicationModel, Set<String> configs) {
        MuleApplicationModel.MuleApplicationModelBuilder builder = new MuleApplicationModel.MuleApplicationModelBuilder();
        builder.setConfigs(configs);
        builder.setMinMuleVersion(originalMuleApplicationModel.getMinMuleVersion());
        builder.setName(originalMuleApplicationModel.getName());
        builder.setRedeploymentEnabled(true);
        builder.setRequiredProduct(originalMuleApplicationModel.getRequiredProduct());
        builder.setSecureProperties(originalMuleApplicationModel.getSecureProperties());
        builder.withBundleDescriptorLoader(originalMuleApplicationModel.getBundleDescriptorLoader());
        builder.withClassLoaderModelDescriptorLoader(originalMuleApplicationModel.getClassLoaderModelLoaderDescriptor());
        return (MuleApplicationModel)builder.build();
    }

    private List<SuiteDeployment> getParameterizedDeployments() {
        return this.suiteRuns.stream().filter(suiteRun -> suiteRun.getParameterization().isPresent()).map(this::createParameterizedSuiteDeployment).collect(Collectors.toList());
    }

    private SuiteDeployment createParameterizedSuiteDeployment(SuiteRun suiteRun) {
        Parameterization parameterization = suiteRun.getParameterization().get();
        return SuiteDeployment.builder().withSuiteRuns(Sets.newHashSet((Object[])new SuiteRun[]{suiteRun})).withSystemProperties(parameterization.getParameters()).withEnableXmlValidations(!suiteRun.isDesignTime()).build();
    }

    private Set<SuiteRun> getDesignTimeSuites() {
        return this.suiteRuns.stream().filter(SuiteRun::isDesignTime).collect(Collectors.toSet());
    }

    private Optional<SuiteDeployment> getDesignTimeSuitesDeployment() {
        Set<SuiteRun> designTimeSuites = this.getDesignTimeSuites().stream().filter(suiteRun -> !suiteRun.getParameterization().isPresent()).collect(Collectors.toSet());
        if (designTimeSuites.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(SuiteDeployment.builder().withSuiteRuns(designTimeSuites).withEnableXmlValidations(false).build());
    }

    private Optional<SuiteDeployment> getRuntimeSuitesDeployment() {
        Set<SuiteRun> runtimeSuites = this.suiteRuns.stream().filter(suiteRun -> !suiteRun.isDesignTime()).filter(suiteRun -> !suiteRun.getParameterization().isPresent()).collect(Collectors.toSet());
        if (runtimeSuites.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(SuiteDeployment.builder().withSuiteRuns(runtimeSuites).withEnableXmlValidations(true).build());
    }

    private Set<String> getDesignTimeSuitesPaths() {
        return this.getDesignTimeSuites().stream().map(SuiteRun::getSuitePath).collect(Collectors.toSet());
    }

    private String getParameterizationName(SuiteRun suiteRun) {
        return suiteRun.getParameterization().map(Parameterization::getParameterizationName).orElse("");
    }

    private String getRuntimeVersion() {
        return this.runConfig.getContainerConfiguration().getRuntimeId();
    }

    private class SkipAfterFailureException
    extends Exception {
        private SkipAfterFailureException() {
        }
    }
}

