/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.container.model;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.remote.properties.Parameterization;

public class SuiteRun {
    private String suitePath;
    private Parameterization parameterization;
    private boolean designTime;
    private boolean ignore;
    private String minMuleVersion;

    private SuiteRun(String suitePath, Parameterization parameterization, boolean designTime, boolean ignore, String minMuleVersion) {
        this.suitePath = suitePath;
        this.parameterization = parameterization;
        this.designTime = designTime;
        this.ignore = ignore;
        this.minMuleVersion = minMuleVersion;
    }

    public String getSuitePath() {
        return this.suitePath;
    }

    public Optional<Parameterization> getParameterization() {
        return Optional.ofNullable(this.parameterization);
    }

    public boolean isDesignTime() {
        return this.designTime;
    }

    public boolean isIgnored() {
        return this.ignore;
    }

    public Optional<String> getMinMuleVersion() {
        return Optional.ofNullable(this.minMuleVersion);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return this.suitePath + this.getParameterization().map(param -> "[" + param.getParameterizationName() + "]").orElse("");
    }

    public static class Builder {
        private String suitePath;
        private Parameterization parameterization;
        private boolean designTime = true;
        private boolean ignore = false;
        private String minMuleVersion;

        private Builder() {
        }

        public Builder withSuitePath(String suitePath) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)suitePath), (Object)"Suite path cannot be blank");
            this.suitePath = suitePath;
            return this;
        }

        public Builder withParameterization(Parameterization parameterization) {
            Preconditions.checkArgument((parameterization != null ? 1 : 0) != 0, (Object)"Parameterization name cannot be null");
            this.parameterization = parameterization;
            return this;
        }

        public Builder withDesignTime(boolean designTime) {
            this.designTime = designTime;
            return this;
        }

        public Builder withIgnore(boolean ignore) {
            this.ignore = ignore;
            return this;
        }

        public Builder withMinMuleVersion(String minMuleVersion) {
            this.minMuleVersion = minMuleVersion;
            return this;
        }

        public SuiteRun build() {
            return new SuiteRun(this.suitePath, this.parameterization, this.designTime, this.ignore, this.minMuleVersion);
        }
    }
}

