/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.properties;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.mule.munit.remote.properties.Parameterization;

public class SuiteConfigParser {
    private static final Namespace MUNIT_NAMESPACE = Namespace.getNamespace((String)"munit", (String)"http://www.mulesoft.org/schema/mule/munit");
    private static final String CONFIG_NAME = "config";
    private static final String PARAMETERIZATIONS_NAME = "parameterizations";
    private static final String PARAMETERIZATION_NAME = "parameterization";
    private static final String PARAMETERS_NAME = "parameters";
    private static final String PARAMETER_NAME = "parameter";
    private static final String PROPERTY_NAME_NAME = "propertyName";
    private static final String VALUE_NAME = "value";
    private static final String NAME_NAME = "name";
    private static final String IGNORE_FIELD = "ignore";
    private static final String MIN_MULE_VERSION_FIELD = "minMuleVersion";
    private Element config;

    public SuiteConfigParser(File suiteFile) {
        try {
            SAXBuilder saxBuilder = new SAXBuilder();
            Document document = saxBuilder.build(suiteFile);
            Element rootElement = document.getRootElement();
            this.config = rootElement.getChild(CONFIG_NAME, MUNIT_NAMESPACE);
        }
        catch (IOException | JDOMException e) {
            this.config = null;
        }
    }

    public Optional<String> getMinMuleVersion() {
        if (this.config == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.config.getAttributeValue(MIN_MULE_VERSION_FIELD));
    }

    public boolean isIgnored() {
        if (this.config == null) {
            return false;
        }
        return Boolean.valueOf(this.config.getAttributeValue(IGNORE_FIELD));
    }

    public Set<Parameterization> parseParameterizations() {
        if (this.config == null) {
            return Collections.emptySet();
        }
        Element parameterizations = this.config.getChild(PARAMETERIZATIONS_NAME, MUNIT_NAMESPACE);
        if (parameterizations == null) {
            return Collections.emptySet();
        }
        return this.collectParameterizedSuites(parameterizations.getChildren(PARAMETERIZATION_NAME, MUNIT_NAMESPACE));
    }

    private Set<Parameterization> collectParameterizedSuites(List<Element> parameterizations) {
        HashSet<Parameterization> parameterizedSuites = new HashSet<Parameterization>();
        for (Element parameterization : parameterizations) {
            HashMap<String, String> parametersMap = new HashMap<String, String>();
            Element parameters = parameterization.getChild(PARAMETERS_NAME, MUNIT_NAMESPACE);
            if (parameters != null) {
                List parameterChildren = parameters.getChildren(PARAMETER_NAME, MUNIT_NAMESPACE);
                for (Element parameter : parameterChildren) {
                    parametersMap.put(parameter.getAttributeValue(PROPERTY_NAME_NAME), parameter.getAttributeValue(VALUE_NAME));
                }
            }
            String name = parameterization.getAttributeValue(NAME_NAME);
            parameterizedSuites.add(new Parameterization(name, parametersMap));
        }
        return parameterizedSuites;
    }
}

