/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.api.configuration;

import java.util.ArrayList;
import java.util.List;
import org.mule.munit.remote.api.configuration.MavenConfiguration;
import org.mule.munit.remote.api.configuration.ServerPluginConfiguration;

public class ContainerConfiguration {
    private String runtimeId;
    private String product;
    private String munitWorkingDirectoryPath;
    private String log4JConfigurationFilePath;
    private MavenConfiguration mavenConfiguration;
    private List<ServerPluginConfiguration> serverPluginConfigurations;

    protected ContainerConfiguration(String runtimeId, String product, String munitWorkingDirectoryPath, String log4JConfigurationFilePath, MavenConfiguration mavenConfiguration, List<ServerPluginConfiguration> serverPluginConfigurations) {
        this.runtimeId = runtimeId;
        this.product = product;
        this.munitWorkingDirectoryPath = munitWorkingDirectoryPath;
        this.log4JConfigurationFilePath = log4JConfigurationFilePath;
        this.mavenConfiguration = mavenConfiguration;
        this.serverPluginConfigurations = serverPluginConfigurations;
    }

    public String getRuntimeId() {
        return this.runtimeId;
    }

    public String getProduct() {
        return this.product;
    }

    public String getMunitWorkingDirectoryPath() {
        return this.munitWorkingDirectoryPath;
    }

    public String getLog4JConfigurationFilePath() {
        return this.log4JConfigurationFilePath;
    }

    public MavenConfiguration getMavenConfiguration() {
        return this.mavenConfiguration;
    }

    public List<ServerPluginConfiguration> getServerPluginConfigurations() {
        return this.serverPluginConfigurations;
    }

    public static class ContainerConfigurationBuilder {
        private String runtimeId;
        private String product;
        private String munitWorkingDirectoryPath;
        private String log4JConfigurationFilePath;
        private MavenConfiguration mavenConfiguration;
        private List<ServerPluginConfiguration> serverPluginConfigurations = new ArrayList<ServerPluginConfiguration>();

        public static ContainerConfigurationBuilder from(ContainerConfiguration cc) {
            ContainerConfigurationBuilder builder = new ContainerConfigurationBuilder();
            builder.withLog4JConfigurationFilePath(cc.getLog4JConfigurationFilePath());
            builder.withMavenConfiguration(cc.getMavenConfiguration());
            cc.getServerPluginConfigurations().forEach(spc -> builder.withServerPluginConfiguration((ServerPluginConfiguration)spc));
            builder.withProduct(cc.getProduct());
            builder.withRuntimeId(cc.getRuntimeId());
            builder.withMunitWorkingDirectoryPath(cc.getMunitWorkingDirectoryPath());
            return builder;
        }

        public ContainerConfigurationBuilder withRuntimeId(String runtimeId) {
            this.runtimeId = runtimeId;
            return this;
        }

        public ContainerConfigurationBuilder withMunitWorkingDirectoryPath(String munitWorkingDirectoryPath) {
            this.munitWorkingDirectoryPath = munitWorkingDirectoryPath;
            return this;
        }

        public ContainerConfigurationBuilder withLog4JConfigurationFilePath(String log4JConfigurationFilePath) {
            this.log4JConfigurationFilePath = log4JConfigurationFilePath;
            return this;
        }

        public ContainerConfigurationBuilder withMavenConfiguration(MavenConfiguration mavenConfiguration) {
            this.mavenConfiguration = mavenConfiguration;
            return this;
        }

        public ContainerConfigurationBuilder withProduct(String product) {
            this.product = product;
            return this;
        }

        public ContainerConfigurationBuilder withServerPluginConfiguration(ServerPluginConfiguration serverPluginConfiguration) {
            this.serverPluginConfigurations.add(serverPluginConfiguration);
            return this;
        }

        public ContainerConfiguration build() {
            return new ContainerConfiguration(this.runtimeId, this.product, this.munitWorkingDirectoryPath, this.log4JConfigurationFilePath, this.mavenConfiguration, this.serverPluginConfigurations);
        }
    }
}

