/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.api.project;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Path;
import org.mule.munit.remote.FolderNames;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.api.project.ApplicationStructureGenerator;
import org.mule.tools.api.packager.archiver.MuleArchiver;
import org.mule.tools.api.packager.archiver.MuleExplodedArchiver;
import org.mule.tools.api.packager.builder.MulePackageBuilder;
import org.mule.tools.api.packager.packaging.PackagingOptions;
import org.mule.tools.api.packager.sources.DefaultValuesMuleArtifactJsonGenerator;
import org.mule.tools.api.packager.sources.MuleArtifactContentResolver;
import org.mule.tools.api.packager.structure.ProjectStructure;

public class MuleApplicationStructureGenerator
implements ApplicationStructureGenerator {
    public static final boolean ONLY_MULE_SOURCES = false;
    public static final boolean LIGHTWEIGHT_PACKAGE = true;
    public static final boolean ATTACH_MULE_SOURCES = false;
    public static final boolean TEST_PACKAGE = true;
    private Path baseFolderPath;
    private Path originFolderPath;
    private MulePackageBuilder packageBuilder;

    public MuleApplicationStructureGenerator(Path baseFolderPath, Path sourceFolder) {
        Preconditions.checkArgument((baseFolderPath != null ? 1 : 0) != 0, (Object)"The base folder must not be null");
        Preconditions.checkArgument((sourceFolder != null ? 1 : 0) != 0, (Object)"The source folder must not be null");
        this.baseFolderPath = baseFolderPath;
        this.originFolderPath = sourceFolder;
        this.packageBuilder = new MulePackageBuilder();
    }

    public MulePackageBuilder getPackageBuilder() {
        return this.packageBuilder;
    }

    public void setPackageBuilder(MulePackageBuilder packageBuilder) {
        this.packageBuilder = packageBuilder;
    }

    @Override
    public Path generate(Path destinationFolder, RunConfiguration runConfiguration) throws Exception {
        Preconditions.checkArgument((destinationFolder != null ? 1 : 0) != 0, (Object)"The destination folder must not be null");
        this.createExplodedPackage(destinationFolder);
        this.reGenerateMuleArtifactJson(destinationFolder);
        return destinationFolder;
    }

    private void createExplodedPackage(Path destinationFolderPath) throws Exception {
        MuleExplodedArchiver archiver = new MuleExplodedArchiver();
        archiver.getArchiver().setDuplicateBehavior("add");
        this.packageBuilder.withPackagingOptions(new PackagingOptions(false, true, false, true)).withArchiver((MuleArchiver)archiver).createPackage(this.originFolderPath, destinationFolderPath);
    }

    private void reGenerateMuleArtifactJson(Path destinationFolderPath) throws IOException {
        Path muleArtifactFolderPath = destinationFolderPath.resolve(FolderNames.META_INF.value()).resolve(FolderNames.MULE_ARTIFACT.value());
        ProjectStructure projectStructure = new ProjectStructure(this.baseFolderPath, true);
        MuleArtifactContentResolver muleArtifactContentResolver = new MuleArtifactContentResolver(projectStructure);
        DefaultValuesMuleArtifactJsonGenerator.generate((Path)muleArtifactFolderPath, (Path)muleArtifactFolderPath, (MuleArtifactContentResolver)muleArtifactContentResolver);
    }
}

