/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.logging;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.mule.munit.common.util.IOUtils;
import org.mule.munit.remote.api.configuration.ContainerConfiguration;

public class Log4jConfigurator {
    public static final String DEFAULT_LOG4J2_CONFIG = "default-log4j2-config.xml";

    public static ConfigurationSource configure(ContainerConfiguration containerConfiguration) throws IOException {
        Validate.notNull((Object)containerConfiguration, (String)"Container configuration should not be null", (Object[])new Object[0]);
        String userLog4jConfig = containerConfiguration.getLog4JConfigurationFilePath();
        URI log4jConfig = StringUtils.isBlank((CharSequence)userLog4jConfig) ? Log4jConfigurator.getDefaultLog4jConfiguration() : Paths.get(userLog4jConfig, new String[0]).toUri();
        ConfigurationSource source = new ConfigurationSource(log4jConfig.toURL().openStream(), log4jConfig.toURL());
        Configurator.initialize(null, (ConfigurationSource)source);
        return source;
    }

    public static URI getDefaultLog4jConfiguration() throws IOException {
        try {
            return IOUtils.getResourceAsUrl((String)DEFAULT_LOG4J2_CONFIG, Log4jConfigurator.class).toURI();
        }
        catch (URISyntaxException e) {
            throw new IOException("Unable to locate default log4j2 configuration file", e);
        }
    }
}

