/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote;

/**
 * <p>
 * Folder names used for folder structure creation
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public enum FolderNames {
  APPLICATION("application"),

  CONTAINER("container"),

  CLASSES("classes"),

  TEST_CLASSES("test-classes"),

  MULE("mule"),

  MUNIT("munit"),

  TEST_MULE("test-mule"),

  MAVEN("maven"),

  META_INF("META-INF"),

  MULE_ARTIFACT("mule-artifact"),

  REPOSITORY("repository"),

  MUNIT_WORKING_DIR("munitworkingdir");

  private String value;

  FolderNames(String value) {
    this.value = value;
  }

  public String value() {
    return this.value;
  }
}
