/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.properties;

import java.io.File;
import java.io.IOException;

import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;

/**
 * Determines if a suite has tests for design time
 *
 * @author Mulesoft Inc.
 * @since 2.2.0
 */
public class DesignTimeSuitesParser {

  // Schema names and namespaces
  private static final Namespace MTF_NAMESPACE = Namespace.getNamespace("mtf", "http://www.mulesoft.org/schema/mule/mtf");
  private static final String TEST_NAME = "tooling-test";

  public boolean hasDesignTimeTests(File suiteFile) {
    try {
      SAXBuilder saxBuilder = new SAXBuilder();
      Document document = saxBuilder.build(suiteFile);
      Element rootElement = document.getRootElement();
      return !rootElement.getChildren(TEST_NAME, MTF_NAMESPACE).isEmpty();
    } catch (JDOMException | IOException e) {
      // In case of any parsing error, we should assume it has not any design time test
      return false;
    }
  }

}
