/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.ParseException;
import org.mule.munit.common.properties.MUnitUserPropertiesManager;
import org.mule.munit.common.protocol.listeners.RemoteRunEventListener;
import org.mule.munit.common.protocol.listeners.RunEventListener;
import org.mule.munit.common.protocol.listeners.RunEventListenerContainer;
import org.mule.munit.common.util.IllegalPortDefinitionException;
import org.mule.munit.common.util.RunnerPortProvider;
import org.mule.munit.common.util.StackTraceUtil;
import org.mule.munit.plugins.coverage.report.model.ApplicationCoverageReport;
import org.mule.munit.remote.api.configuration.CoverageConfiguration;
import org.mule.munit.remote.api.configuration.NotifierConfiguration;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.api.configuration.RunConfigurationParser;
import org.mule.munit.remote.classloading.ClassLoaderUtils;
import org.mule.munit.remote.container.ContainerFactory;
import org.mule.munit.remote.container.ContainerManager;
import org.mule.munit.remote.container.SuiteRunDispatcher;
import org.mule.munit.remote.container.SuiteRunLocator;
import org.mule.munit.remote.container.model.SuiteRun;
import org.mule.munit.remote.coverage.CoverageManager;
import org.mule.munit.remote.exception.DeploymentException;
import org.mule.munit.remote.notifier.NotifierReflectionFactory;
import org.mule.runtime.module.embedded.api.EmbeddedContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteRunner {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String SYSTEM_PROPERTIES_FILE = "munit.system.properties.file";
    public static final String MUNIT_DEBUG_LOG_CLASSPATH = "munit.debug.log.classpath";
    private ContainerFactory containerFactory;

    public static void main(String[] args) throws ParseException, IOException, URISyntaxException {
        RemoteRunner.loadSystemProperties();
        RunConfiguration runConfig = new RunConfigurationParser().parse(args);
        RemoteRunner runner = new RemoteRunner();
        runner.setContainerFactory(new ContainerFactory());
        runner.run(runConfig);
        RemoteRunner.shutDown();
    }

    public void setContainerFactory(ContainerFactory containerFactory) {
        this.containerFactory = containerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunConfiguration runConfig) throws IOException, URISyntaxException {
        Integer munitRunnerPort;
        this.logger.info("Run Started");
        this.logClassPathIfNecessary();
        RemoteRunEventListener listener = this.buildRunnerListener(runConfig.getNotifierConfigurations());
        listener.notifyRunStart();
        try {
            munitRunnerPort = new RunnerPortProvider().getPort();
        }
        catch (IllegalPortDefinitionException e) {
            listener.notifyUnexpectedError(StackTraceUtil.getStackTrace((Throwable)e));
            listener.notifyRunFinish();
            this.logger.info("Done");
            return;
        }
        EmbeddedContainer container = this.containerFactory.createContainer(runConfig.getContainerConfiguration());
        ContainerManager containerManager = new ContainerManager(container, runConfig);
        SuiteRunDispatcher suiteRunDispatcher = this.buildSuiteRunDispatcher(runConfig, munitRunnerPort, containerManager);
        Optional<CoverageManager> coverageManager = this.buildCoverageManager(runConfig.getCoverageConfiguration());
        try {
            container.start();
            coverageManager.ifPresent(CoverageManager::startCoverageServer);
            containerManager.deployDomain();
            suiteRunDispatcher.runSuites(listener);
        }
        catch (DeploymentException e) {
            listener.notifyContainerFailure(StackTraceUtil.getStackTrace((Throwable)e));
        }
        catch (Throwable e) {
            e.printStackTrace();
            listener.notifyUnexpectedError(StackTraceUtil.getStackTrace((Throwable)e));
        }
        finally {
            container.stop();
        }
        coverageManager.ifPresent(CoverageManager::stopCoverageServer);
        coverageManager.ifPresent(manager -> this.sendCoverageReport((CoverageManager)manager, listener));
        listener.notifyRunFinish();
        this.logger.info("Done");
    }

    protected SuiteRunDispatcher buildSuiteRunDispatcher(RunConfiguration runConfig, Integer munitRunnerPort, ContainerManager containerManager) {
        Set<SuiteRun> suiteRuns = new SuiteRunLocator(runConfig).locate();
        return new SuiteRunDispatcher(containerManager, munitRunnerPort, runConfig, suiteRuns);
    }

    protected RemoteRunEventListener buildRunnerListener(List<NotifierConfiguration> configurations) throws IOException {
        List<RunEventListener> listeners = new NotifierReflectionFactory().createNotifiers(configurations);
        RunEventListenerContainer container = new RunEventListenerContainer();
        listeners.forEach(arg_0 -> ((RunEventListenerContainer)container).addNotificationListener(arg_0));
        return container;
    }

    private void logClassPathIfNecessary() {
        if (Boolean.valueOf(System.getProperty(MUNIT_DEBUG_LOG_CLASSPATH, "false")).booleanValue()) {
            this.logger.info("logging classpath ...");
            new ClassLoaderUtils().getClassPath().forEach(System.out::println);
            this.logger.info("logging classpath DONE");
        }
    }

    private Optional<CoverageManager> buildCoverageManager(CoverageConfiguration coverageConfiguration) {
        if (coverageConfiguration == null) {
            return Optional.empty();
        }
        Integer coverageServerPort = coverageConfiguration.getCoveragePort();
        Boolean randomizeCoveragePort = coverageConfiguration.isRandomizeCoveragePort();
        CoverageManager coverageManager = new CoverageManager(randomizeCoveragePort, coverageServerPort, coverageConfiguration.isRunCoverage(), coverageConfiguration.getSuitePaths());
        coverageManager.setIgnoreFlows(Optional.ofNullable(coverageConfiguration.getIgnoredFlowNames()).orElse(Collections.emptySet()));
        coverageManager.setIgnoreFiles(Optional.ofNullable(coverageConfiguration.getIgnoredFiles()).orElse(Collections.emptySet()));
        return Optional.ofNullable(coverageManager);
    }

    private void sendCoverageReport(CoverageManager coverageManager, RemoteRunEventListener listener) {
        Optional<ApplicationCoverageReport> coverageReport = coverageManager.generateCoverageReport();
        if (coverageReport.isPresent()) {
            String coverageReportJson = new Gson().toJson((Object)coverageReport.get());
            listener.notifyCoverageReport(coverageReportJson);
        }
    }

    private static void loadSystemProperties() {
        RemoteRunner.loadSystemPropertiesFileIfPresent();
    }

    private static void loadSystemPropertiesFileIfPresent() {
        String filePath = System.getProperty(SYSTEM_PROPERTIES_FILE);
        try {
            if (filePath != null) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(new File(filePath)));
                MUnitUserPropertiesManager.loadPropertiesToSystem((Properties)properties);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void shutDown() {
        System.exit(0);
    }
}

