/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.api.configuration;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ServerPluginConfiguration {
    private String groupId;
    private String artifactId;
    private String version;
    private String baseVersion;
    private String type;
    private String classifier;
    private Map<String, String> properties;

    protected ServerPluginConfiguration(String groupId, String artifactId, String version, String baseVersion, String type, String classifier, Map<String, String> properties) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.baseVersion = baseVersion;
        this.type = type;
        this.classifier = classifier;
        this.properties = properties;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBaseVersion() {
        return this.baseVersion;
    }

    public String getType() {
        return this.type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static class ServerPluginConfigurationBuilder {
        private String groupId;
        private String artifactId;
        private String version;
        private String baseVersion;
        private String type = "jar";
        private String classifier;
        private Map<String, String> properties;

        public ServerPluginConfigurationBuilder withGroupId(String groupId) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)groupId), (Object)"Group Id cannot be blank");
            this.groupId = groupId;
            return this;
        }

        public ServerPluginConfigurationBuilder withArtifactId(String artifactId) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)artifactId), (Object)"Artifact Id cannot be blank");
            this.artifactId = artifactId;
            return this;
        }

        public ServerPluginConfigurationBuilder withVersion(String version) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)version), (Object)"Version cannot be blank");
            this.version = version;
            return this;
        }

        public ServerPluginConfigurationBuilder withBaseVersion(String baseVersion) {
            this.baseVersion = baseVersion;
            return this;
        }

        public ServerPluginConfigurationBuilder withType(String type) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)type), (Object)"Type cannot be blank");
            this.type = type;
            return this;
        }

        public ServerPluginConfigurationBuilder withClassifier(String classifier) {
            this.classifier = classifier;
            return this;
        }

        public ServerPluginConfigurationBuilder withProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public ServerPluginConfiguration build() {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.groupId), (Object)"Group Id cannot be blank");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.artifactId), (Object)"Artifact Id cannot be blank");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.version), (Object)"Version cannot be blank");
            return new ServerPluginConfiguration(this.groupId, this.artifactId, this.version, this.baseVersion, this.type, this.classifier, this.properties);
        }
    }
}

