/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.container;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.munit.common.protocol.listeners.RemoteRunEventListener;
import org.mule.munit.common.util.FileUtils;
import org.mule.munit.common.util.IOUtils;
import org.mule.munit.common.util.StackTraceUtil;
import org.mule.munit.common.util.VersionUtils;
import org.mule.munit.remote.FolderNames;
import org.mule.munit.remote.api.client.RunnerClient;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.container.ContainerManager;
import org.mule.munit.remote.container.model.SuiteDeployment;
import org.mule.munit.remote.container.model.SuiteRun;
import org.mule.munit.remote.exception.DeploymentException;
import org.mule.munit.remote.properties.Parameterization;
import org.mule.munit.remote.properties.deploy.DeploymentProperties;
import org.mule.munit.remote.properties.deploy.MuleRuntimeDeploymentProperties;
import org.mule.munit.remote.properties.deploy.TemporaryFolderProperties;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuiteRunDispatcher {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(SuiteRunDispatcher.class);
    private final ContainerManager containerManager;
    private final RunConfiguration runConfig;
    private final Integer munitRunnerPort;
    private final MuleApplicationModel originalMuleApplicationModel;
    private final Set<SuiteRun> suiteRuns;
    private final Collection<DeploymentProperties> deploymentProperties;

    public SuiteRunDispatcher(ContainerManager containerManager, Integer munitRunnerPort, RunConfiguration runConfiguration, Set<SuiteRun> suiteRuns) {
        this.containerManager = containerManager;
        this.runConfig = runConfiguration;
        this.munitRunnerPort = munitRunnerPort;
        this.suiteRuns = suiteRuns;
        this.originalMuleApplicationModel = this.getOriginalApplicationModel();
        this.deploymentProperties = this.getDeploymentProperties();
    }

    private MuleApplicationModel getOriginalApplicationModel() {
        try {
            File muleArtifactJsonFile = this.getMuleArtifactJsonFile();
            return (MuleApplicationModel)new MuleApplicationModelJsonSerializer().deserialize(IOUtils.toString((URI)muleArtifactJsonFile.toURI(), (Charset)Charset.defaultCharset()));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private Collection<DeploymentProperties> getDeploymentProperties() {
        ArrayList<DeploymentProperties> deploymentProperties = new ArrayList<DeploymentProperties>();
        deploymentProperties.add(new MuleRuntimeDeploymentProperties(this.runConfig));
        deploymentProperties.add(new TemporaryFolderProperties());
        return deploymentProperties;
    }

    private File getMuleArtifactJsonFile() {
        File applicationDirectory = new File(this.runConfig.getContainerConfiguration().getMunitWorkingDirectoryPath(), this.runConfig.getProjectName());
        return Paths.get(applicationDirectory.toURI()).resolve(FolderNames.META_INF.value()).resolve(FolderNames.MULE_ARTIFACT.value()).resolve("mule-artifact.json").toFile();
    }

    public void runSuites(RemoteRunEventListener listener) throws DeploymentException {
        try {
            Collection<SuiteDeployment> suiteDeployments = this.generateSuiteDeployments();
            Map<String, String> initialProperties = this.getInitialProperties(suiteDeployments);
            for (SuiteDeployment suiteDeployment : suiteDeployments) {
                this.performSuiteDeploy(listener, suiteDeployment, initialProperties);
            }
        }
        catch (SkipAfterFailureException e) {
            LOGGER.debug("Skipped running suites since skipAfterFailure is on");
        }
    }

    private Collection<SuiteDeployment> generateSuiteDeployments() {
        ArrayList<SuiteDeployment> suiteDeployments = new ArrayList<SuiteDeployment>();
        suiteDeployments.addAll(this.getParameterizedDeployments());
        this.getDesignTimeSuitesDeployment().ifPresent(suiteDeployments::add);
        this.getRuntimeSuitesDeployment().ifPresent(suiteDeployments::add);
        return suiteDeployments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSuiteDeploy(RemoteRunEventListener listener, SuiteDeployment suiteDeployment, Map<String, String> initialProperties) throws SkipAfterFailureException {
        Set<SuiteRun> suiteRuns = suiteDeployment.getSuiteRuns();
        if (suiteRuns.stream().noneMatch(this::shouldRunSuite)) {
            LOGGER.info("Suite run for suites " + suiteRuns + " will not start since no suites will run");
            return;
        }
        try {
            this.removeSuitesThatWontRun(suiteRuns);
            Map<String, String> systemProperties = this.getSystemProperties(initialProperties, suiteDeployment);
            this.containerManager.deployApplication(suiteDeployment.isEnableXmlValidations(), systemProperties);
            for (SuiteRun suiteRun : suiteRuns) {
                if (this.shouldRunSuite(suiteRun)) {
                    String parameterizationName;
                    String suitePath = suiteRun.getSuitePath();
                    boolean success = this.runSuite(this.runConfig, listener, suitePath, parameterizationName = this.getParameterizationName(suiteRun));
                    if (success || !this.runConfig.isSkipAfterFailure().booleanValue()) continue;
                    throw new SkipAfterFailureException();
                }
                this.showSuiteSkippedMessage(suiteRun);
            }
        }
        catch (DeploymentException e) {
            if (suiteRuns.size() > 1) {
                listener.notifyContainerFailure(StackTraceUtil.getStackTrace((Throwable)e));
            } else {
                SuiteRun suiteRun = suiteRuns.iterator().next();
                listener.notifyContainerFailure(suiteRun.getSuitePath(), this.getParameterizationName(suiteRun), StackTraceUtil.getStackTrace((Throwable)e));
            }
        }
        finally {
            this.containerManager.undeployApplication();
        }
    }

    private void removeSuitesThatWontRun(Set<SuiteRun> suiteRuns) {
        Set suitesToRun = suiteRuns.stream().filter(this::shouldRunSuite).map(SuiteRun::getSuitePath).collect(Collectors.toSet());
        Set<String> newConfigs = this.originalMuleApplicationModel.getConfigs().stream().filter(config -> this.isNonSuiteConfigFile((String)config) || suitesToRun.contains(config)).collect(Collectors.toSet());
        try {
            MuleApplicationModel muleApplicationModel = SuiteRunDispatcher.overrideConfigs(this.originalMuleApplicationModel, newConfigs);
            String newMuleApplicationModelString = new MuleApplicationModelJsonSerializer().serialize((AbstractMuleArtifactModel)muleApplicationModel);
            FileUtils.write((File)this.getMuleArtifactJsonFile(), (CharSequence)newMuleApplicationModelString, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new IllegalStateException("An error occurred while regenerating the Mule Application Model", e);
        }
    }

    private boolean isNonSuiteConfigFile(String config) {
        return !this.runConfig.getAllSuitePaths().contains(config);
    }

    private Map<String, String> getSystemProperties(Map<String, String> initialProperties, SuiteDeployment suiteDeployment) {
        HashMap<String, String> systemProperties = new HashMap<String, String>(initialProperties);
        this.deploymentProperties.forEach(properties -> systemProperties.putAll((Map)properties.get()));
        systemProperties.putAll(suiteDeployment.getSystemProperties());
        return systemProperties;
    }

    private void showSuiteSkippedMessage(SuiteRun suiteRun) {
        String message = "Suite " + suiteRun.getSuitePath() + " will not be deployed: ";
        if (suiteRun.isIgnored()) {
            message = message + "Suite is ignored";
        } else if (!this.isCurrentRuntimeAtLeastMinVersion(suiteRun).booleanValue()) {
            message = message + String.format("Current runtime version [%s] is lower that suite's minMuleVersion [%s]", this.getRuntimeVersion(), suiteRun.getMinMuleVersion().orElse("N/A"));
        } else if (!this.isSuiteFiltered(suiteRun)) {
            message = message + "Suite was filtered from running";
        } else if (!this.isCurrentRuntimeProductAllowedToRun(suiteRun)) {
            message = message + String.format("Suite is expected to run only with runtime product [%s] and the current runtime is [%s]", suiteRun.getRequiredProduct(), this.getContainerRuntimeProduct());
        }
        LOGGER.info(message);
    }

    private boolean runSuite(RunConfiguration runConfig, RemoteRunEventListener listener, String suitePath, String parameterizationName) {
        try {
            RunnerClient runnerClient = this.getRunnerClient(listener);
            runnerClient.sendSuiteRunInfo(runConfig.getRunToken(), suitePath, parameterizationName, runConfig.getTestNames(), runConfig.getTags());
            return runnerClient.receiveAndNotify();
        }
        catch (IOException | ClassNotFoundException | RuntimeException e) {
            listener.notifyContainerFailure(suitePath, parameterizationName, StackTraceUtil.getStackTrace((Throwable)e));
            return false;
        }
    }

    protected RunnerClient getRunnerClient(RemoteRunEventListener listener) throws IOException {
        return new RunnerClient(this.munitRunnerPort, listener);
    }

    private boolean shouldRunSuite(SuiteRun suiteRun) {
        return !suiteRun.isIgnored() && this.isCurrentRuntimeAtLeastMinVersion(suiteRun) != false && this.isSuiteFiltered(suiteRun) && this.isCurrentRuntimeProductAllowedToRun(suiteRun);
    }

    private Boolean isCurrentRuntimeAtLeastMinVersion(SuiteRun suiteRun) {
        return suiteRun.getMinMuleVersion().map(minMuleVersion -> VersionUtils.isAtLeastMinMuleVersion((String)this.getRuntimeVersion(), (String)minMuleVersion)).orElse(true);
    }

    private boolean isSuiteFiltered(SuiteRun suiteRun) {
        return this.runConfig.getSuitePaths().contains(suiteRun.getSuitePath());
    }

    private boolean isCurrentRuntimeProductAllowedToRun(SuiteRun suiteRun) {
        Product containerRuntimeProduct = this.getContainerRuntimeProduct();
        Product currentSuiteRequiredProduct = suiteRun.getRequiredProduct();
        return currentSuiteRequiredProduct != Product.MULE_EE || containerRuntimeProduct == Product.MULE_EE;
    }

    private Map<String, String> getInitialProperties(Collection<SuiteDeployment> suiteDeployments) {
        HashMap<String, String> initialProperties = new HashMap<String, String>();
        suiteDeployments.forEach(suite -> initialProperties.putAll(suite.getSystemProperties()));
        return initialProperties;
    }

    public static MuleApplicationModel overrideConfigs(MuleApplicationModel originalMuleApplicationModel, Set<String> configs) {
        MuleApplicationModel.MuleApplicationModelBuilder builder = new MuleApplicationModel.MuleApplicationModelBuilder();
        builder.setConfigs(configs);
        builder.setMinMuleVersion(originalMuleApplicationModel.getMinMuleVersion());
        builder.setName(originalMuleApplicationModel.getName());
        builder.setRedeploymentEnabled(true);
        builder.setRequiredProduct(originalMuleApplicationModel.getRequiredProduct());
        builder.setSecureProperties(originalMuleApplicationModel.getSecureProperties());
        builder.withBundleDescriptorLoader(originalMuleApplicationModel.getBundleDescriptorLoader());
        builder.withClassLoaderModelDescriptorLoader(originalMuleApplicationModel.getClassLoaderModelLoaderDescriptor());
        return (MuleApplicationModel)builder.build();
    }

    private List<SuiteDeployment> getParameterizedDeployments() {
        return this.suiteRuns.stream().filter(suiteRun -> suiteRun.getParameterization().isPresent()).map(this::createParameterizedSuiteDeployment).collect(Collectors.toList());
    }

    private SuiteDeployment createParameterizedSuiteDeployment(SuiteRun suiteRun) {
        Parameterization parameterization = suiteRun.getParameterization().get();
        return SuiteDeployment.builder().withSuiteRuns(Sets.newHashSet((Object[])new SuiteRun[]{suiteRun})).withSystemProperties(parameterization.getParameters()).withEnableXmlValidations(!suiteRun.isDesignTime()).build();
    }

    private Set<SuiteRun> getDesignTimeSuites() {
        return this.suiteRuns.stream().filter(SuiteRun::isDesignTime).collect(Collectors.toSet());
    }

    private Optional<SuiteDeployment> getDesignTimeSuitesDeployment() {
        Set<SuiteRun> designTimeSuites = this.getDesignTimeSuites().stream().filter(suiteRun -> !suiteRun.getParameterization().isPresent()).collect(Collectors.toSet());
        if (designTimeSuites.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(SuiteDeployment.builder().withSuiteRuns(designTimeSuites).withEnableXmlValidations(false).build());
    }

    private Optional<SuiteDeployment> getRuntimeSuitesDeployment() {
        Set<SuiteRun> runtimeSuites = this.suiteRuns.stream().filter(suiteRun -> !suiteRun.isDesignTime()).filter(suiteRun -> !suiteRun.getParameterization().isPresent()).collect(Collectors.toSet());
        if (runtimeSuites.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(SuiteDeployment.builder().withSuiteRuns(runtimeSuites).withEnableXmlValidations(true).build());
    }

    private String getParameterizationName(SuiteRun suiteRun) {
        return suiteRun.getParameterization().map(Parameterization::getParameterizationName).orElse("");
    }

    private String getRuntimeVersion() {
        return this.runConfig.getContainerConfiguration().getRuntimeId();
    }

    private Product getContainerRuntimeProduct() {
        String containerRuntimeProduct = this.runConfig.getContainerConfiguration().getProduct();
        if (containerRuntimeProduct == null) {
            return null;
        }
        return Product.valueOf((String)containerRuntimeProduct);
    }

    private class SkipAfterFailureException
    extends Exception {
        private SkipAfterFailureException() {
        }
    }
}

