/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.logging;

import static org.apache.commons.lang3.StringUtils.isBlank;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;

import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.mule.munit.common.util.IOUtils;
import org.mule.munit.remote.api.configuration.ContainerConfiguration;

/**
 * Configures the log4j2 context based on the container configuration
 * 
 * @since 2.0.0
 * @author Mulesoft Inc.
 */
public class Log4jConfigurator {


  public static final String DEFAULT_LOG4J2_CONFIG = "default-log4j2-config.xml";

  public static ConfigurationSource configure(ContainerConfiguration containerConfiguration) throws IOException {
    Validate.notNull(containerConfiguration, "Container configuration should not be null");
    String userLog4jConfig = containerConfiguration.getLog4JConfigurationFilePath();
    URI log4jConfig = isBlank(userLog4jConfig) ? getDefaultLog4jConfiguration() : Paths.get(userLog4jConfig).toUri();
    ConfigurationSource source = new ConfigurationSource(log4jConfig.toURL().openStream(), log4jConfig.toURL());
    Configurator.initialize(null, source);
    return source;
  }

  public static URI getDefaultLog4jConfiguration() throws IOException {
    try {
      return IOUtils.getResourceAsUrl(DEFAULT_LOG4J2_CONFIG, Log4jConfigurator.class).toURI();
    } catch (URISyntaxException e) {
      throw new IOException("Unable to locate default log4j2 configuration file", e);
    }
  }

}
