/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.tools.client.BAT;

import org.mule.tools.client.authentication.AuthenticationServiceClient;
import org.mule.tools.client.authentication.model.AnypointCredential;
import org.mule.tools.client.authentication.model.ConnectedAppCredentials;
import org.mule.tools.client.authentication.model.Credentials;

/**
 * Client for BAT Executions services
 *
 * @author Mulesoft Inc.
 * @since 2.3.0
 */
public class BATClient extends BATClientBase {

  protected final AnypointCredential credentials;
  private final AuthenticationServiceClient authenticationServiceClient;

  public BATClient(String baseUri, AnypointCredential credentials, AuthenticationServiceClient authenticationServiceClient) {
    super(baseUri);
    this.credentials = credentials;
    this.authenticationServiceClient = authenticationServiceClient;
  }

  protected String getBearerToken() {
    if (credentials instanceof Credentials) {
      return authenticationServiceClient.getBearerToken((Credentials) credentials);
    } else if (credentials instanceof ConnectedAppCredentials) {
      return authenticationServiceClient.getBearerTokenForConnectedApp((ConnectedAppCredentials) credentials);
    }

    throw new RuntimeException("Credentials type not supported.");
  }

  protected String getOrganizationId() {
    return authenticationServiceClient.getMe().user.organization.id;
  }

  @Override
  public void renewToken() {
    this.bearerToken = getBearerToken();
  }

}
