/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.api.configuration;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.mule.munit.remote.api.configuration.DeploymentType;
import org.mule.tools.model.Deployment;
import org.mule.tools.model.anypoint.ArmDeployment;
import org.mule.tools.model.anypoint.CloudHubDeployment;

@JsonAdapter(value=DeploymentConfigurationAdapter.class)
public class DeploymentConfiguration {
    private Deployment deployment;
    private DeploymentType deploymentType;

    public DeploymentConfiguration(DeploymentType deploymentType, Deployment deployment) {
        this.deployment = deployment;
        this.deploymentType = deploymentType;
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    static class UserCredentialsExclusionStrategy
    implements ExclusionStrategy {
        UserCredentialsExclusionStrategy() {
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return fieldAttributes.getName().equalsIgnoreCase("username") || fieldAttributes.getName().equalsIgnoreCase("password");
        }

        public boolean shouldSkipClass(Class<?> aClass) {
            return false;
        }
    }

    static class DeploymentConfigurationAdapter
    extends TypeAdapter<DeploymentConfiguration> {
        private static final String TYPE = "type";
        private static final String VALUE = "value";
        private static final Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new UserCredentialsExclusionStrategy()).create();

        DeploymentConfigurationAdapter() {
        }

        public void write(JsonWriter out, DeploymentConfiguration value) throws IOException {
            out.beginObject();
            out.name(TYPE);
            out.value(value.getDeploymentType().name());
            out.name(VALUE);
            switch (value.getDeploymentType()) {
                case CLOUDHUB: {
                    gson.toJson((Object)value.getDeployment(), CloudHubDeployment.class, out);
                    break;
                }
                case ARM: {
                    gson.toJson((Object)value.getDeployment(), ArmDeployment.class, out);
                }
            }
            out.endObject();
        }

        public DeploymentConfiguration read(JsonReader in) throws IOException {
            in.beginObject();
            if (!TYPE.equals(in.nextName())) {
                throw new IOException("Deployment configuration serialized does not have the type field");
            }
            String containerTypeValue = in.nextString();
            DeploymentType containerType = DeploymentType.fromValue(containerTypeValue);
            if (containerType == null) {
                throw new IOException("Deployment configuration type not found, value was " + containerTypeValue);
            }
            if (!VALUE.equals(in.nextName())) {
                throw new IOException("Deployment configuration serialized does not have the value field");
            }
            Deployment deployment = null;
            switch (containerType) {
                case CLOUDHUB: {
                    deployment = (Deployment)gson.fromJson(in, CloudHubDeployment.class);
                    break;
                }
                case ARM: {
                    deployment = (Deployment)gson.fromJson(in, ArmDeployment.class);
                }
            }
            in.endObject();
            return new DeploymentConfiguration(containerType, deployment);
        }
    }
}

