/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.api.configuration;

import org.mule.tools.model.Deployment;
import org.mule.tools.model.anypoint.ArmDeployment;
import org.mule.tools.model.anypoint.CloudHubDeployment;

/**
 * List the deployment types
 *
 * @author Mulesoft Inc.
 * @since 2.3.0
 */
public enum DeploymentType {

  EMBEDDED, CLOUDHUB, ARM;

  public static DeploymentType fromValue(String value) {
    for (DeploymentType type : values()) {
      if (type.name().equals(value)) {
        return type;
      }
    }
    return null;
  }

  public static DeploymentType fromDeployment(Deployment deployment) {
    if (deployment instanceof CloudHubDeployment) {
      return CLOUDHUB;
    } else if (deployment instanceof ArmDeployment) {
      return ARM;
    }
    return null;
  }
}
