/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.api.configuration;

import java.util.ArrayList;
import java.util.List;
import org.mule.munit.remote.api.configuration.Repository;

public class MavenConfiguration {
    private String settingsXmlFilePath;
    private String globalSettingsXmlFilePath;
    private String mavenRepositoryDirectoryPath;
    private String securitySettingsFilePath;
    private Boolean offlineMode = Boolean.FALSE;
    private Boolean forcePolicyUpdate = Boolean.FALSE;
    private boolean ignoreArtifactDescriptorRepositories = Boolean.TRUE;
    private List<Repository> remoteRepositories;

    protected MavenConfiguration(String settingsXmlFilePath, String globalSettingsXmlFilePath, String mavenRepositoryDirectoryPath, String securitySettingsFilePath, Boolean forcePolicyUpdate, Boolean offlineMode, Boolean ignoreArtifactDescriptorRepositories, List<Repository> remoteRepositories) {
        this.settingsXmlFilePath = settingsXmlFilePath;
        this.globalSettingsXmlFilePath = globalSettingsXmlFilePath;
        this.mavenRepositoryDirectoryPath = mavenRepositoryDirectoryPath;
        this.securitySettingsFilePath = securitySettingsFilePath;
        this.offlineMode = offlineMode;
        this.forcePolicyUpdate = forcePolicyUpdate;
        this.ignoreArtifactDescriptorRepositories = ignoreArtifactDescriptorRepositories;
        this.remoteRepositories = remoteRepositories;
    }

    public String getSettingsXmlFilePath() {
        return this.settingsXmlFilePath;
    }

    public String getGlobalSettingsXmlFilePath() {
        return this.globalSettingsXmlFilePath;
    }

    public String getMavenRepositoryDirectoryPath() {
        return this.mavenRepositoryDirectoryPath;
    }

    public String getSecuritySettingsFilePath() {
        return this.securitySettingsFilePath;
    }

    public Boolean getOfflineMode() {
        return this.offlineMode;
    }

    public Boolean getForcePolicyUpdate() {
        return this.forcePolicyUpdate;
    }

    public boolean getIgnoreArtifactDescriptorRepositories() {
        return this.ignoreArtifactDescriptorRepositories;
    }

    public List<Repository> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public static class MavenConfigurationBuilder {
        private String settingsXmlFilePath;
        private String globalSettingsXmlFilePath;
        private String mavenRepositoryDirectoryPath;
        private String securitySettingsFilePath;
        private Boolean offlineMode = Boolean.FALSE;
        private Boolean forcePolicyUpdate = Boolean.FALSE;
        private Boolean ignoreArtifactDescriptorRepositories = Boolean.TRUE;
        private List<Repository> remoteRepositories = new ArrayList<Repository>();

        public static MavenConfigurationBuilder from(MavenConfiguration mc) {
            MavenConfigurationBuilder builder = new MavenConfigurationBuilder();
            builder.withSettingsXmlFilePath(mc.getSettingsXmlFilePath()).withGlobalSettingsXmlFilePath(mc.getGlobalSettingsXmlFilePath()).withMavenRepositoryDirectoryPath(mc.getMavenRepositoryDirectoryPath()).withSecuritySettingsFilePath(mc.getSecuritySettingsFilePath()).withForcePolicyUpdate(mc.getForcePolicyUpdate()).withOfflineMode(mc.getOfflineMode());
            return builder;
        }

        public MavenConfigurationBuilder withSettingsXmlFilePath(String settingsXmlFilePath) {
            this.settingsXmlFilePath = settingsXmlFilePath;
            return this;
        }

        public MavenConfigurationBuilder withGlobalSettingsXmlFilePath(String globalSettingsXmlFilePath) {
            this.globalSettingsXmlFilePath = globalSettingsXmlFilePath;
            return this;
        }

        public MavenConfigurationBuilder withMavenRepositoryDirectoryPath(String mavenRepositoryDirectoryPath) {
            this.mavenRepositoryDirectoryPath = mavenRepositoryDirectoryPath;
            return this;
        }

        public MavenConfigurationBuilder withForcePolicyUpdate(Boolean forcePolicyUpdate) {
            this.forcePolicyUpdate = forcePolicyUpdate;
            return this;
        }

        public MavenConfigurationBuilder withOfflineMode(Boolean offlineMode) {
            this.offlineMode = offlineMode;
            return this;
        }

        public MavenConfigurationBuilder withIgnoreArtifactDescriptorRepositories(Boolean ignoreArtifactDescriptorRepositories) {
            this.ignoreArtifactDescriptorRepositories = ignoreArtifactDescriptorRepositories;
            return this;
        }

        public MavenConfigurationBuilder withSecuritySettingsFilePath(String securitySettingsFilePath) {
            this.securitySettingsFilePath = securitySettingsFilePath;
            return this;
        }

        public MavenConfigurationBuilder withRemoteRepositories(List<Repository> remoteRepositories) {
            this.remoteRepositories = remoteRepositories;
            return this;
        }

        public MavenConfiguration build() {
            return new MavenConfiguration(this.settingsXmlFilePath, this.globalSettingsXmlFilePath, this.mavenRepositoryDirectoryPath, this.securitySettingsFilePath, this.forcePolicyUpdate, this.offlineMode, this.ignoreArtifactDescriptorRepositories, this.remoteRepositories);
        }
    }
}

