/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.api.configuration;

import com.google.gson.Gson;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.mule.munit.remote.api.configuration.RunConfiguration;

public class RunConfigurationParser {
    public static final String RUN_CONFIGURATION_PARAMETER = "run_configuration";
    private static final int MIN_PORT_NUMBER = 50000;
    private static final int MAX_PORT_NUMBER = 55000;
    private Options options = new Options();
    private CommandLineParser parser = new BasicParser();

    public RunConfigurationParser() {
        this.options.addOption(this.createOption(RUN_CONFIGURATION_PARAMETER, true, "MUnit run configuration", true));
    }

    public RunConfiguration parse(String[] args) throws ParseException, IOException {
        CommandLine cmdLine = this.parser.parse(this.options, args);
        return this.buildRunConfiguration(cmdLine);
    }

    private RunConfiguration buildRunConfiguration(CommandLine cmd) throws IOException {
        String param = cmd.getOptionValue(RUN_CONFIGURATION_PARAMETER, "");
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(param), StandardCharsets.UTF_8);
        return (RunConfiguration)new Gson().fromJson((Reader)reader, RunConfiguration.class);
    }

    private Option createOption(String name, String description) {
        return this.createOption(name, true, description, false);
    }

    private Option createOption(String name, boolean hasArg, String description, boolean required) {
        OptionBuilder.withDescription((String)description);
        OptionBuilder.hasArg((boolean)hasArg);
        OptionBuilder.isRequired((boolean)required);
        return OptionBuilder.create((String)name);
    }
}

