/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.properties.deploy;

import java.util.HashMap;
import java.util.Map;
import org.mule.munit.common.util.VersionUtils;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.properties.deploy.DeploymentProperties;

public class MuleRuntimeDeploymentProperties
implements DeploymentProperties {
    protected static final String PROCESSING_STRATEGY_FACTORY = "org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory";
    protected static final String PROCESSING_STRATEGY_FACTORY_IMPL = "org.mule.runtime.core.internal.processor.strategy.TransactionAwareProactorStreamEmitterProcessingStrategyFactory";
    protected static final String PROCESSING_STRATEGY_MIN_VERSION = "4.2.0";
    protected static final String MULE_DISABLE_ASYNC_RETRY_POLICY_ON_SOURCES = "mule.disableAsyncRetryPolicyOnSources";
    private RunConfiguration runConfiguration;

    public MuleRuntimeDeploymentProperties(RunConfiguration runConfiguration) {
        this.runConfiguration = runConfiguration;
    }

    @Override
    public Map<String, String> get() {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.setFactoryProperty(properties);
        this.setForceSyncReconnection(properties);
        return properties;
    }

    private void setForceSyncReconnection(Map<String, String> properties) {
        if (System.getProperty(MULE_DISABLE_ASYNC_RETRY_POLICY_ON_SOURCES) == null) {
            properties.put(MULE_DISABLE_ASYNC_RETRY_POLICY_ON_SOURCES, Boolean.TRUE.toString());
        }
    }

    public void setFactoryProperty(Map<String, String> properties) {
        String runtimeVersion = this.runConfiguration.getContainerConfiguration().getRuntimeId();
        if (System.getProperty(PROCESSING_STRATEGY_FACTORY) == null && VersionUtils.isAtLeastMinMuleVersion((String)runtimeVersion, (String)PROCESSING_STRATEGY_MIN_VERSION)) {
            properties.put(PROCESSING_STRATEGY_FACTORY, PROCESSING_STRATEGY_FACTORY_IMPL);
        }
    }
}

