/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.jaxrs;

import com.owlike.genson.Genson;
import com.owlike.genson.GensonBuilder;
import com.owlike.genson.ext.jaxb.JAXBBundle;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.ext.ContextResolver;

public final class GensonJaxRSFeature
implements ContextResolver<GensonJaxRSFeature> {
    private static final Genson _defaultGenson = new GensonBuilder().withBundle(new JAXBBundle()).useConstructorWithArguments(true).create();
    private boolean enabled = true;
    private Set<Class<?>> notSerializableTypes = new HashSet();
    private Set<Class<?>> notDeserializableTypes = new HashSet();
    private Genson genson = _defaultGenson;

    @Override
    public GensonJaxRSFeature getContext(Class<?> type) {
        return this;
    }

    public GensonJaxRSFeature disable() {
        this.enabled = false;
        return this;
    }

    public GensonJaxRSFeature enable() {
        this.enabled = true;
        return this;
    }

    public GensonJaxRSFeature use(Genson genson) {
        this.genson = genson;
        return this;
    }

    public Genson genson() {
        return this.genson;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public GensonJaxRSFeature disableSerializationFor(Class<?> type, Class<?> ... types) {
        this.notSerializableTypes.add(type);
        for (Class<?> t2 : types) {
            this.notSerializableTypes.add(t2);
        }
        return this;
    }

    public GensonJaxRSFeature disableDeserializationFor(Class<?> type, Class<?> ... types) {
        this.notDeserializableTypes.add(type);
        for (Class<?> t2 : types) {
            this.notDeserializableTypes.add(t2);
        }
        return this;
    }

    public boolean isSerializable(Class<?> type) {
        return !this.notSerializableTypes.contains(type);
    }

    public boolean isDeserializable(Class<?> type) {
        return !this.notDeserializableTypes.contains(type);
    }
}

