/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.jsr353;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.json.JsonNumber;
import javax.json.JsonValue;

abstract class GensonJsonNumber
implements JsonNumber {
    GensonJsonNumber() {
    }

    @Override
    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.NUMBER;
    }

    static class DoubleJsonNumber
    extends GensonJsonNumber {
        private final double value;
        private BigDecimal exactValue;

        protected DoubleJsonNumber(double value) {
            this.value = value;
        }

        protected DoubleJsonNumber(BigDecimal value) {
            this.exactValue = value;
            this.value = this.exactValue.doubleValue();
        }

        @Override
        public boolean isIntegral() {
            return false;
        }

        @Override
        public int intValue() {
            return (int)this.value;
        }

        @Override
        public int intValueExact() {
            return (int)this.value;
        }

        @Override
        public long longValue() {
            return (long)this.value;
        }

        @Override
        public long longValueExact() {
            return (long)this.value;
        }

        @Override
        public BigInteger bigIntegerValue() {
            return this.bigDecimalValue().toBigInteger();
        }

        @Override
        public BigInteger bigIntegerValueExact() {
            return this.bigDecimalValue().toBigIntegerExact();
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public BigDecimal bigDecimalValue() {
            if (this.exactValue == null) {
                this.exactValue = BigDecimal.valueOf(this.value);
            }
            return this.exactValue;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DoubleJsonNumber that = (DoubleJsonNumber)o;
            return this.bigDecimalValue().equals(that.bigDecimalValue());
        }

        @Override
        public int hashCode() {
            return this.bigDecimalValue().hashCode();
        }

        @Override
        public String toString() {
            return Double.toString(this.value);
        }
    }

    static class IntJsonNumber
    extends GensonJsonNumber {
        private final long value;
        private BigInteger exactValue;

        protected IntJsonNumber(long value) {
            this.value = value;
        }

        IntJsonNumber(BigInteger exactValue) {
            this.exactValue = exactValue;
            this.value = exactValue.longValue();
        }

        @Override
        public boolean isIntegral() {
            return true;
        }

        @Override
        public int intValue() {
            return (int)this.value;
        }

        @Override
        public int intValueExact() {
            return (int)this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public long longValueExact() {
            return this.value;
        }

        @Override
        public BigInteger bigIntegerValue() {
            return BigInteger.valueOf(this.value);
        }

        @Override
        public BigInteger bigIntegerValueExact() {
            return BigInteger.valueOf(this.value);
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public BigDecimal bigDecimalValue() {
            return BigDecimal.valueOf(this.value);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IntJsonNumber that = (IntJsonNumber)o;
            return this.bigIntegerValue().equals(that.bigIntegerValue());
        }

        @Override
        public int hashCode() {
            return this.bigIntegerValue().hashCode();
        }

        @Override
        public String toString() {
            return Long.toString(this.value);
        }
    }
}

