/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.jsr353;

import com.owlike.genson.ext.jsr353.JSR353Bundle;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

class GensonJsonObject
implements JsonObject {
    private final Map<String, JsonValue> values;

    GensonJsonObject(Map<String, JsonValue> values) {
        this.values = values;
    }

    @Override
    public JsonArray getJsonArray(String name) {
        return (JsonArray)JsonArray.class.cast(this.values.get(name));
    }

    @Override
    public JsonObject getJsonObject(String name) {
        return (JsonObject)JsonObject.class.cast(this.values.get(name));
    }

    @Override
    public JsonNumber getJsonNumber(String name) {
        return (JsonNumber)JsonNumber.class.cast(this.values.get(name));
    }

    @Override
    public JsonString getJsonString(String name) {
        return (JsonString)JsonString.class.cast(this.values.get(name));
    }

    @Override
    public String getString(String name) {
        return this.getJsonString(name).getString();
    }

    @Override
    public String getString(String name, String defaultValue) {
        return this.isNull(name) ? defaultValue : this.getString(name);
    }

    @Override
    public int getInt(String name) {
        return this.getJsonNumber(name).intValue();
    }

    @Override
    public int getInt(String name, int defaultValue) {
        return this.isNull(name) ? defaultValue : this.getInt(name);
    }

    @Override
    public boolean getBoolean(String name) {
        JsonValue value = this.values.get(name);
        if (JsonValue.TRUE.equals(value)) {
            return true;
        }
        if (JsonValue.FALSE.equals(value)) {
            return false;
        }
        throw new ClassCastException();
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        return this.isNull(name) ? defaultValue : this.getBoolean(name);
    }

    @Override
    public boolean isNull(String name) {
        JsonValue value = this.values.get(name);
        return JsonValue.NULL.equals(value) || value == null;
    }

    @Override
    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.OBJECT;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.values.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.containsValue(value);
    }

    @Override
    public JsonValue get(Object key) {
        return this.values.get(key);
    }

    @Override
    public JsonValue put(String key, JsonValue value) {
        return this.values.put(key, value);
    }

    @Override
    public JsonValue remove(Object key) {
        return this.values.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends JsonValue> m4) {
        this.values.putAll(m4);
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.values.keySet();
    }

    @Override
    public Collection<JsonValue> values() {
        return this.values.values();
    }

    @Override
    public Set<Map.Entry<String, JsonValue>> entrySet() {
        return this.values.entrySet();
    }

    @Override
    public JsonValue getOrDefault(Object key, JsonValue defaultValue) {
        return this.values.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super JsonValue> action) {
        this.values.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super JsonValue, ? extends JsonValue> function) {
        this.values.replaceAll(function);
    }

    @Override
    public JsonValue putIfAbsent(String key, JsonValue value) {
        return this.values.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.values.remove(key, value);
    }

    @Override
    public boolean replace(String key, JsonValue oldValue, JsonValue newValue) {
        return this.values.replace(key, oldValue, newValue);
    }

    @Override
    public JsonValue replace(String key, JsonValue value) {
        return this.values.replace(key, value);
    }

    @Override
    public JsonValue computeIfAbsent(String key, Function<? super String, ? extends JsonValue> mappingFunction) {
        return this.values.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public JsonValue computeIfPresent(String key, BiFunction<? super String, ? super JsonValue, ? extends JsonValue> remappingFunction) {
        return this.values.computeIfPresent(key, remappingFunction);
    }

    @Override
    public JsonValue compute(String key, BiFunction<? super String, ? super JsonValue, ? extends JsonValue> remappingFunction) {
        return this.values.compute(key, remappingFunction);
    }

    @Override
    public JsonValue merge(String key, JsonValue value, BiFunction<? super JsonValue, ? super JsonValue, ? extends JsonValue> remappingFunction) {
        return this.values.merge(key, value, remappingFunction);
    }

    @Override
    public boolean equals(Object o) {
        return this.values.equals(o);
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }

    @Override
    public String toString() {
        return JSR353Bundle.toString(this);
    }
}

